package com.elitesland.scp.application.service.wqf;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.resp.wqf.ScpWqfEntAccountPageParam;
import com.elitesland.scp.application.facade.vo.resp.wqf.ScpWqfEntAccountPageVO;
import com.elitesland.scp.domain.entity.wqf.ScpWqfEntAccountDO;
import com.elitesland.scp.infr.repo.wqf.ScpWqfEntAccountRepo;
import com.elitesland.scp.infr.repo.wqf.ScpWqfEntAccountRepoProc;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 03月 03日 10:36
 * @version: 1.0
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ScpWqfEntAccountServiceImpl implements ScpWqfEntAccountService {

    private final ScpWqfEntAccountRepoProc scpWqfEntAccountRepoProc;

    private final OrgOuRpcService orgOuRpcService;

    private final OrgStoreRpcService orgStoreRpcService;

    private final ScpWqfEntAccountRepo scpWqfEntAccountRepo;

    @Override
    @SysCodeProc
    public PagingVO<ScpWqfEntAccountPageVO> page(ScpWqfEntAccountPageParam paramVO) {
        PagingVO<ScpWqfEntAccountPageVO> page = scpWqfEntAccountRepoProc.page(paramVO);
        if(CollectionUtils.isNotEmpty(page.getRecords())){
            List<Long> ouIds = page.getRecords().stream().map(ScpWqfEntAccountPageVO::getOuId).distinct().collect(Collectors.toList());
            List<Long> storeIds = page.getRecords().stream().map(ScpWqfEntAccountPageVO::getStoreId).distinct().collect(Collectors.toList());
            List<OrgOuRpcSimpleDTO> simpleOuDto = orgOuRpcService.findSimpleOuDto(ouIds);
            Map<Long, OrgOuRpcSimpleDTO> ouMap = simpleOuDto.stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getId, v -> v, (e1, e2) -> e1));
            List<OrgStoreDetailRpcDTO> storeDetailRpcDTOS = orgStoreRpcService.queryByIds(storeIds);
            Map<Long, OrgStoreDetailRpcDTO> storeMap = storeDetailRpcDTOS.stream().collect(Collectors.toMap(OrgStoreDetailRpcDTO::getId, v -> v, (e1, e2) -> e1));
            for(ScpWqfEntAccountPageVO vo : page.getRecords()){
                OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(vo.getOuId());
                if(ouRpcSimpleDTO != null){
                    vo.setOuName(ouRpcSimpleDTO.getOuName());
                    vo.setOuCode(ouRpcSimpleDTO.getOuCode());
                }
                OrgStoreDetailRpcDTO storeDetailRpcDTO = storeMap.get(vo.getStoreId());
                if(storeDetailRpcDTO != null){
                    vo.setStoreName(storeDetailRpcDTO.getStoreName());
                }
            }
        }
        return page;
    }

    @Override
    @Transactional
    public List<Long> enable(List<Long> ids) {
        List<ScpWqfEntAccountDO> wqfEntAccountDOS = scpWqfEntAccountRepo.findByIdIn(ids);
        wqfEntAccountDOS.stream().filter(d -> Boolean.TRUE.equals(d.getStatus())).findAny().ifPresent(d ->{
            throw new RuntimeException("启用失败,请选择【未启用】状态单据");
        });
        wqfEntAccountDOS.forEach(d ->{
            d.setStatus(Boolean.TRUE);
        });
        scpWqfEntAccountRepo.saveAll(wqfEntAccountDOS);
        return ids;
    }

    @Override
    @Transactional
    public List<Long> disable(List<Long> ids) {
        List<ScpWqfEntAccountDO> wqfEntAccountDOS = scpWqfEntAccountRepo.findByIdIn(ids);
        wqfEntAccountDOS.stream().filter(d -> Boolean.FALSE.equals(d.getStatus())).findAny().ifPresent(d ->{
            throw new RuntimeException("请选择【启用】状态单据");
        });
        wqfEntAccountDOS.forEach(d ->{
            d.setStatus(Boolean.FALSE);
        });
        scpWqfEntAccountRepo.saveAll(wqfEntAccountDOS);
        return ids;
    }
}
