package com.elitesland.scp.domain.entity.alloc;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class ScpAllocSettingRedisDO implements Serializable {
    private static final long serialVersionUID = -4892561478153648138L;

    private List<ScpAllocSettingRedisDO.ActivityDO> activityList;

    @Data
    public static class ActivityDO {

        private Long activityId;

        private String activityCode;

        private LocalDateTime validFrom;

        private LocalDateTime validTo;

        @ApiModelProperty("最大强配次数")
        private Integer maxNum;

        @ApiModelProperty("已配次数")
        private Integer allocNum;

        private Boolean enabled;

        private List<String> docTypes;

        private List<ScpAllocSettingRedisDO.ActivityDO.InnerItemDO> innerItemDOS;

        @Data
        public static class InnerItemDO {

            @ApiModelProperty("活动ID")
            private Long masId;

            @ApiModelProperty("商品ID")
            private Long itemId;

            @ApiModelProperty("商品编码")
            private String itemCode;

            @ApiModelProperty("商品名称")
            private String itemName;

            @ApiModelProperty("商品分类")
            private String itemType2;

            @ApiModelProperty("最小强配数量")
            private BigDecimal minNum;

            @ApiModelProperty("图片")
            private String imgUrl;
        }
    }
}
