package com.elitesland.scp.domain.entity.article;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serial;
import java.io.Serializable;

@Entity
@Table(name = "scp_article_info", indexes = {
})
@Comment("文章信息")
@Getter
@Setter
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class ArticleInfoDO extends BaseModel implements Serializable {
    @Serial
    private static final long serialVersionUID = -4254921460115216468L;

    @Column(name = "article_author")
    private String articleAuthor;

    @Column(name = "article_name")
    private String articleName;

    @Column(name = "article_code")
    private String articleCode;

    @Column(name = "sort_no")
    private Integer sortNo;

    @Column(name = "show_flag")
    private String showFlag;

    @Column(name = "category_id")
    private Long categoryId;

    @Column(name = "category_name")
    private String categoryName;

    @Column(name = "article_detail")
    private String articleDetail;
}
