package com.elitesland.scp.provider.mrp;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDPlanRespVO;
import com.elitesland.scp.domain.entity.mrp.ScpMrpDO;
import com.elitesland.scp.domain.service.mrp.ScpMrpDPlanDomainService;
import com.elitesland.scp.domain.service.mrp.ScpMrpDomainService;
import com.elitesland.scp.dto.mrp.ScpMrpDPlanCancelDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.service.mrp.ScpMrpRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;


@Slf4j
@Service
@RestController
@RequiredArgsConstructor
@RequestMapping(ScpApplication.URI_PREFIX + ScpMrpRpcService.PATH)
public class ScpMrpRpcServiceImpl implements ScpMrpRpcService {

    private final ScpMrpDomainService scpMrpDomainService;

    private final ScpMrpDPlanDomainService scpMrpDPlanDomainService;

    @Override
    public ApiResult<Long> cancelPlan(ScpMrpDPlanCancelDTO cancelDTO) {
        log.info("【cancelMrpDPlan】取消MRP采购计划：{}", JSONUtil.toJsonStr(cancelDTO));
        ScpMrpDO scpMrpDO = scpMrpDomainService.findById(cancelDTO.getMrpId());
        if (scpMrpDO == null) {
            throw new BusinessException("MRP计划不存在");
        }
        if (CollectionUtil.isEmpty(cancelDTO.getPodIds())) {
            throw new BusinessException("采购订单明细不能为空");
        }
        List<ScpMrpDPlanRespVO> scpMrpDPlanRespVOList = scpMrpDPlanDomainService.findByMrpId(cancelDTO.getMrpId());
        List<Long> cancelPlanIds = scpMrpDPlanRespVOList.stream().filter(plan -> plan.getPoDId() != null && cancelDTO.getPodIds().contains(plan.getPoDId())).map(ScpMrpDPlanRespVO::getId).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(cancelPlanIds)) {
            throw new BusinessException("MRP采购计划明细不存在");
        }
        String mrpPushStatus = scpMrpDPlanRespVOList.stream().anyMatch(plan -> plan.getPoDId() == null || !cancelDTO.getPodIds().contains(plan.getId())) ? ScpUdcEnum.MRP_PUSH_STATUS_PART.getValueCode() : ScpUdcEnum.MRP_PUSH_STATUS_NOT.getValueCode();

        // 更新推送状态
        scpMrpDPlanDomainService.updatePushStatus(cancelPlanIds, ScpUdcEnum.MRP_D_PUSH_STATUS_NOT.getValueCode(), null, null, null, null);
        scpMrpDomainService.updatePushStatus(cancelDTO.getMrpId(), mrpPushStatus, null);
        return ApiResult.ok();
    }
}
