/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.redis.util.RedisUtils;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MessageDelyQueueService {
    private static final Logger log = LoggerFactory.getLogger(MessageDelyQueueService.class);
    private final RedisUtils redisUtils;
    private static final String DELY_QUEUE_NAME = "scp_dely_queue";

    public Boolean pushMessage(String message, long dely) {
        long score = System.currentTimeMillis() + dely;
        return this.redisUtils.getRedisTemplate().opsForZSet().add((Object)DELY_QUEUE_NAME, (Object)message, (double)score);
    }

    public String pull() {
        Set strings = this.redisUtils.getRedisTemplate().opsForZSet().rangeByScore((Object)DELY_QUEUE_NAME, 0.0, (double)System.currentTimeMillis(), 0L, 1L);
        if (CollUtil.isNotEmpty((Collection)strings)) {
            return (String)strings.iterator().next();
        }
        return null;
    }

    public Boolean remove(String message) {
        Long remove = this.redisUtils.getRedisTemplate().opsForZSet().remove((Object)DELY_QUEUE_NAME, new Object[]{message});
        return remove > 0L;
    }

    public String getOrderExpireTime(String message) {
        Double score = this.redisUtils.getRedisTemplate().opsForZSet().score((Object)DELY_QUEUE_NAME, (Object)("SCP_ONLINE_PAY:" + message));
        if (ObjectUtil.isNotNull((Object)score) && score - (double)System.currentTimeMillis() > 0.0) {
            double time = (score - (double)System.currentTimeMillis()) / 1000.0;
            return DateUtil.secondToTime((int)((int)time));
        }
        return "00:00:00";
    }

    public void resettingOrderExpireTime(String orderNo, Long expireTime) {
        String orderKey = "SCP_ONLINE_PAY:" + orderNo;
        this.redisUtils.getRedisTemplate().opsForZSet().remove((Object)DELY_QUEUE_NAME, new Object[]{orderKey});
        this.pushMessage(orderKey, expireTime);
    }

    public MessageDelyQueueService(RedisUtils redisUtils) {
        this.redisUtils = redisUtils;
    }
}

