package com.elitesland.scp.application.facade.vo.resp.calendar;

import com.elitescloud.boot.common.param.AreaVO;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
@ApiModel("门店订货日历配置分页返回")
public class ScpStoreCalendarSetLinePageRespVO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = -3138925240131174177L;

    @ApiModelProperty("主表ID")
    private Long masId;

    @ApiModelProperty("星期x")
    private Integer todayWeek;

    @ApiModelProperty("门店ID")
    private Long storeId;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty("经营性质")
    @SysCode(sys = "yst-supp", mod = "STORE_TYPE2")
    private String storeType2;
    private String storeType2Name;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("品牌编码")
    private String brandCode;

    @ApiModelProperty("品牌名称")
    private String brandName;

    @ApiModelProperty("区域编码")
    private String regionCode;

    @ApiModelProperty("区域名称")
    private String regionName;

    @ApiModelProperty(value = "配置方式")
    @SysCode(sys = "yst-suplan", mod = "CALENDAR_CONFIG_METHOD")
    private String type;
    private String typeName;

    @ApiModelProperty("适用对象名称")
    private String applicableObjName;

    @ApiModelProperty("状态")
    private Boolean enabled;

    @ApiModelProperty("适用属性，[UDC]yst-supp:STORE_TYPE2")
    private List<CodeNameParam> applicableAttrList;

    @ApiModelProperty("适用属性名称")
    private List<CodeNameParam> applicableAttrNameList;

    @ApiModelProperty("匹配行政区域")
    private List<AreaVO> areaList;

    @ApiModelProperty("上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("上级组织名称")
    private String parentOrgName;
}
