package com.elitesland.scp.application.facade.vo.resp.mrp;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

@Data
@ApiModel("千元用量导出")
@ExcelIgnoreUnannotated
public class ScpThousandUseRefExportVO implements Serializable {

    public Integer rowNo;

    @ApiModelProperty(value = "门店名称")
    private String stWhName;

    @ApiModelProperty(value = "门店编码")
    private String stWhCode;

    @ApiModelProperty(value = "门店类型")
    private String stWhType;
    /** 商品编码 */
    @ApiModelProperty("商品编码")
    private String itemCode;
    /** 商品名称 */
    @ApiModelProperty("商品名称")
    private String itemName;
    /** 类型 */
    @ApiModelProperty("类型")
    private String itemType;

    /** 商品规格 */
    @ApiModelProperty("商品规格")
    private String itemAttr;

    /** 商品辅助单位 [UDC]COM:UOM */
    @ApiModelProperty("商品辅助单位 [UDC]COM:UOM")
    private String uom2Name;

    /** 预估千元用量 */
    @ApiModelProperty("预估千元用量")
    private BigDecimal estimateThousNum;
    /** 调整千元用量 */
    @ApiModelProperty("调整千元用量")
    private BigDecimal adjustThousNum;

    @ApiModelProperty(value = "参考日期开始")
    private String referenceDataStart;

    @ApiModelProperty(value = "参考日期结束")
    private String referenceDataEnd;

    @ApiModelProperty(value = "有效日期开始")
    private String validDataStart;

    @ApiModelProperty(value = "有效日期结束")
    private String validDataEnd;
}
