package com.elitesland.scp.application.facade.vo.resp.order;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel("支付订单列表")
public class ScpPayOrderPageRespVO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = 89032174603295367L;

    @ApiModelProperty("关联单据号")
    private String srcDocNo;

    @ApiModelProperty("关联单据类别")
    private String srcDocCls;

    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId;

    @ApiModelProperty("订货单编码")
    private String docCode;
    @ApiModelProperty("订货单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long docId;

    @ApiModelProperty("单据类别")
    @SysCode(sys = "yst-suplan", mod = "OB_DOC_CLS")
    private String docCls;
    private String docClsName;

    @ApiModelProperty("单据类型")
    @SysCode(sys = "yst-suplan", mod = "OB_DOC_TYPE")
    private String docType;
    private String docTypeName;

    @ApiModelProperty("单据状态")
    @SysCode(sys = "yst-suplan", mod = "DEO_STATUS")
    private String docStatus;
    private String docStatusName;

    @ApiModelProperty("付款状态")
    @SysCode(sys = "yst-suplan", mod = "PAY_STATUS")
    private String payStatus;
    private String payStatusName;

    @ApiModelProperty("关联单据金额")
    private BigDecimal amt;

    @ApiModelProperty("销售公司编码")
    private String saleOuCode;

    @ApiModelProperty("销售公司名称")
    private String saleOuName;

    @ApiModelProperty("商品图片集合")
    private List<String> itemImgUrls;

}
