package com.elitesland.scp.application.facade.vo.save.order;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel(value = "订货订单明细保存参数")
public class ScpDemandOrderDSaveVO implements Serializable {
    private static final long serialVersionUID = 2310302359745458378L;

    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty(value = "订货订单ID", required = true)
    @NotNull(message = "订货订单ID不能为空")
    private Long masId;

    @ApiModelProperty("原始id")
    private Long sourceId;

    @ApiModelProperty("行号")
    private BigDecimal lineNo;

    @ApiModelProperty("SPU商品编码")
    @NotNull(message = "SPU商品编码不能为空")
    private String spuItemCode;
    @ApiModelProperty("SPU商品名称")
    private String spuItemName;

    @ApiModelProperty(value = "商品id", required = true)
    @NotNull(message = "商品id不能为空")
    private Long itemId;

    @ApiModelProperty(value = "商品编码", required = true)
    @NotBlank(message = "商品编码不能为空")
    private String itemCode;

    @ApiModelProperty(value = "商品名称", required = true)
    @NotBlank(message = "商品名称不能为空")
    private String itemName;

    @ApiModelProperty("商品分类")
    @NotBlank(message = "商品分类不能为空")
    private String itemType;

    @ApiModelProperty("配送方式")
    @NotBlank(message = "配送方式不能为空")
    private String deliveryType;

    @ApiModelProperty(value = "需求数量", required = true)
    @NotNull(message = "需求数量不能为空")
    private BigDecimal demandQuantity;

    @ApiModelProperty("拆分需求数量")
    private BigDecimal allocationDeQuantity;

    @ApiModelProperty(value = "仓库/供应商分配比例", required = true)
    @NotNull(message = "仓库/供应商分配比例不能为空")
    private BigDecimal ratio;

    @ApiModelProperty("订货单位")
    private String unit;
    @ApiModelProperty(value = "订货单位")
    private String unitName;

    @ApiModelProperty("基本单位")
    private String uom2;
    @ApiModelProperty(value = "基本单位名称")
    private String uom2Name;

    @ApiModelProperty("运费是否需要计费")
    private Boolean freightFlag;

    @ApiModelProperty("运费比例")
    private BigDecimal freightRatio;

    @ApiModelProperty("基本单位数量")
    private BigDecimal qty2;

    @ApiModelProperty("单位转换系数")
    private BigDecimal uomRatio;

    @ApiModelProperty("有效位数")
    private Integer decimalPlaces;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("币种，默认CNY")
    private String currency;

    @ApiModelProperty("分配数量")
    private BigDecimal allocationQuantity;

    @ApiModelProperty(value = "供应类型,WH:仓库，SUPP:供应商", required = true)
    @NotBlank(message = "供应类型不能为空")
    private String supplyType;

    @ApiModelProperty(value = "供应仓库id、供应商id", required = true)
    @NotNull(message = "供应仓库id不能为空")
    private Long suppWhId;

    @ApiModelProperty(value = "供应仓库编码、供应商编码", required = true)
    @NotBlank(message = "供应仓库编码不能为空")
    private String suppWhCode;

    @ApiModelProperty(value = "供应仓库名称、供应商名称", required = true)
    @NotBlank(message = "供应仓库名称不能为空")
    private String suppWhName;

    @ApiModelProperty("采购公司id")
    private Long ouId;

    @ApiModelProperty("采购公司编码")
    private String ouCode;

    @ApiModelProperty("采购公司名称")
    private String ouName;

    @ApiModelProperty("分配单据id")
    private Long srcDocId;

    @ApiModelProperty("分配单据编码")
    private String srcDocNo;

    @ApiModelProperty("分配单据类别")
    private String srcDocCls;

    @ApiModelProperty("分配单据明细行号")
    private String srcDocLineNo;

    @ApiModelProperty("发货数量")
    private BigDecimal quantity;

    @ApiModelProperty("是否已计算")
    private Boolean isCalculated;

    @ApiModelProperty("是否已推送")
    private Boolean isPushed;

    @ApiModelProperty(value = "含税金额")
    private BigDecimal planAmt;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("计划数量")
    private BigDecimal planQuantity;

    @ApiModelProperty(value = "预分配唯一值", hidden = true)
    private String preRootUuid;

    @ApiModelProperty("销售公司编码")
    private String saleOuCode;

    @ApiModelProperty("销售公司名称")
    private String saleOuName;

    @ApiModelProperty("销售客户编码")
    private String saleCustCode;

    @ApiModelProperty("付款状态")
    private String payStatus;
    @ApiModelProperty("运费行标记")
    private Boolean freightLineFlag;

    @ApiModelProperty("赠品行标记")
    private Boolean giftLineFlag;

    @ApiModelProperty(value = "需求金额")
    private BigDecimal demandAmt;

    @ApiModelProperty(value = "商品图片地址")
    private String imgUrl;

    private Long activityId;

    @ApiModelProperty(value = "强配活动编码")
    private String activityCode;

    @ApiModelProperty(value = "最小数量")
    private BigDecimal minNum;

    @ApiModelProperty("折扣比例")
    private BigDecimal discount;

    @ApiModelProperty("货款单价（不含服务费）")
    private BigDecimal salePrice;

    @ApiModelProperty("货款金额")
    private BigDecimal saleAmt;

    @ApiModelProperty("结算单价")
    private BigDecimal settlementPrice;

    @ApiModelProperty("结算金额")
    private BigDecimal settlementAmt;

    @ApiModelProperty("结算货款单价")
    private BigDecimal settlementSalePrice;

    @ApiModelProperty("结算货款金额")
    private BigDecimal settlementSaleAmt;

    @ApiModelProperty("科技费")
    private BigDecimal techFee;

    @ApiModelProperty("营销费")
    private BigDecimal marketingFee;

    @ApiModelProperty("运营费")
    private BigDecimal operationFee;

    @ApiModelProperty("科技费价格")
    private BigDecimal tefPrice;

    @ApiModelProperty("营销费价格")
    private BigDecimal mefPrice;

    @ApiModelProperty("运营费价格")
    private BigDecimal oefPrice;

    @ApiModelProperty("是否收取项目费用")
    private Boolean isProjFeeCharged;

    @ApiModelProperty("项目费用标记")
    private Boolean projectFeeFlag;

    @ApiModelProperty("费用类型")
    private String costType;

    @ApiModelProperty("科技服务费用归属公司")
    private String tefFeeOuCode;

    @ApiModelProperty("运营费服务费用归属公司")
    private String oefFeeOuCode;

    @ApiModelProperty("营销费服务费用归属公司")
    private String mefFeeOuCode;

    @ApiModelProperty("科技服务费用归属公司")
    private String tefFeeOuName;

    @ApiModelProperty("运营费服务费用归属公司")
    private String oefFeeOuName;

    @ApiModelProperty("营销费服务费用归属公司")
    private String mefFeeOuName;

    @ApiModelProperty("组合商品编码")
    private String combineItemCode;

    @ApiModelProperty("组合商品名称")
    private String combineItemName;

    @ApiModelProperty("组合商品标识")
    private Boolean combineItemFlag;

    @ApiModelProperty("是否预售")
    private Boolean preSaleStatus;

    public String groupByUuid() {
        return this.itemId.toString() + this.preRootUuid;
    }
}
