package com.elitesland.scp.domain.convert.setting;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingParamVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.setting.ScpOrderSettingSaveVO;
import com.elitesland.scp.domain.entity.setting.ScpOrderSettingDO;
import com.elitesland.scp.infr.dto.setting.ScpOrderSettingDTO;
import com.elitesland.scp.param.ScpOrderSettingRpcParamVO;
import com.elitesland.scp.param.ScpOrderSettingRpcRespVO;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @Author: ryan.xu
 * @since 2024/07/12
 */
@Mapper(config = BaseMapperConfig.class)
public interface ScpOrderSettingConvert {
    ScpOrderSettingConvert INSTANCE = Mappers.getMapper(ScpOrderSettingConvert.class);

    ScpOrderSettingRespVO dtoToRespVO(ScpOrderSettingDTO settingDTO);

    ScpOrderSettingDTO doToDto(ScpOrderSettingDO settingDO);

    ScpOrderSettingDO saveVoToDO(ScpOrderSettingSaveVO saveVO);

    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    void copySaveParamToDo(ScpOrderSettingSaveVO saveVO, @MappingTarget ScpOrderSettingDO settingDO);

    ScpOrderSettingRespVO doToRespVO(ScpOrderSettingDO settingDO);

    ScpOrderSettingParamVO apiParmToServiceParam(ScpOrderSettingRpcParamVO settingDO);

    List<ScpOrderSettingRpcRespVO> ServiceRespToApiRespList(List<ScpOrderSettingRespVO> dataList);

    ScpOrderSettingRpcRespVO ServiceRespToApiResp(ScpOrderSettingRespVO data);


}
