package com.elitesland.scp.domain.service.purLimit;



import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.save.purLimit.ScpPurLimitSettingItemSaveVO;

import java.util.List;

public interface ScpPurLimitSettingItemDomainService {


    /**
     * 订货强配活动明细查询
     *
     * @param masId
     * @return
     */
    List<ScpPurLimitSettingItemRespVO> findByMasId(Long masId);

    /**
     * 订货强配活动明细保存
     *
     * @param saveVOS 保存单据类型配置的值对象
     * @return 返回保存后的单据类型配置的ID
     */
    void batchSavePurLimitSettingItem(List<ScpPurLimitSettingItemSaveVO> saveVOS);

    /**
     * 删除订货强配活动明细
     *
     * @param masId
     */
    void deleteByMasId(Long masId);

    /**
     * 删除订货强配活动明细
     *
     * @param ids
     */
    void deleteByIds(List<Long> ids);

    /**
     * 根据门店编码查询订货强配活动明细
     *
     * @param storeCode
     * @param itemTypes
     * @return
     */
    List<ScpPurLimitSettingItemRespVO> getEnablePurLimitSettingItemByStoreCode(String storeCode, List<String> itemTypes);

        /**
     * 根据门店查询
     *
     * @param storeId
     * @return
     */
    List<Long> findMasIdByItemId(Long storeId);
}
