package com.elitesland.scp.domain.vo.article;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
@ApiModel(description = "文章新增编辑入参")
public class ArticleInfoSaveVO extends BaseModel implements Serializable {

    @ApiModelProperty("文章作者")
    @NotBlank(message = "文章作者不能为空")
    private String articleAuthor;

    @ApiModelProperty("文章名称")
    @NotBlank(message = "文章名称不能为空")
    private String articleName;

    @ApiModelProperty("文章编码")
    private String articleCode;

    @ApiModelProperty("文章排序")
    private Integer sortNo;

    @ApiModelProperty(value = "是否显示 HIDE-隐藏 DISPLAY-显示")
    @NotBlank(message = "是否显示不能为空")
    private String showFlag;

    @ApiModelProperty("文章分类id")
    @NotNull(message = "文章分类id不能为空")
    private Long categoryId;

    @ApiModelProperty("文章分类名称")
//    @NotBlank(message = "文章分类不能为空")
    private String categoryName;

//    @ApiModelProperty("文章分类code")
//    private String categoryCode;

    @ApiModelProperty("文章详情")
    private String articleDetail;

}
