package com.elitesland.scp.infr.repo.alloc;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStorePageParamVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStoreParamVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingStoreRespVO;
import com.elitesland.scp.domain.entity.alloc.QScpAllocSettingDO;
import com.elitesland.scp.domain.entity.alloc.QScpAllocSettingStoreDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Component
@RequiredArgsConstructor
public class ScpAllocSettingStoreRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QScpAllocSettingStoreDO scpAllocSettingStoreDO = QScpAllocSettingStoreDO.scpAllocSettingStoreDO;
    private static final QScpAllocSettingDO scpAllocSettingDO = QScpAllocSettingDO.scpAllocSettingDO;

    public long countAllocSettingStore(ScpAllocSettingStorePageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpAllocSettingStoreDO.count())
                .from(scpAllocSettingStoreDO);
        jpaQuery.where(this.whereAllocSettingPage(paramVO));
        return jpaQuery.fetchCount();
    }

    private final QBean<ScpAllocSettingStoreRespVO> pageList = Projections.bean(
            ScpAllocSettingStoreRespVO.class,
            scpAllocSettingStoreDO.id,
            scpAllocSettingStoreDO.masId,
            scpAllocSettingStoreDO.storeId,
            scpAllocSettingStoreDO.storeCode,
            scpAllocSettingStoreDO.storeName,
            scpAllocSettingStoreDO.storeType2,
            scpAllocSettingStoreDO.maxNum

    );

    public List<ScpAllocSettingStoreRespVO> queryAllocSettingStore(ScpAllocSettingStorePageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(pageList)
                .from(scpAllocSettingStoreDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpAllocSettingStoreDO);
        jpaQuery.where(this.whereAllocSettingPage(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate whereAllocSettingPage(ScpAllocSettingStorePageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (paramVO.getMasId() != null) {
            predicates.add(scpAllocSettingStoreDO.masId.eq(paramVO.getMasId()));
        }
        if (CollUtil.isNotEmpty(paramVO.getStoreCodes())) {
            predicates.add(scpAllocSettingStoreDO.storeCode.in(paramVO.getStoreCodes()));
        }
        if (StrUtil.isNotBlank(paramVO.getStoreCode())) {
            predicates.add(scpAllocSettingStoreDO.storeCode.eq(paramVO.getStoreCode()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<Long> findMasIdByStoreCodeIn(List<String> storeCodes, Set<Long> masIds) {
        JPAQuery<Long> where = jpaQueryFactory.select(scpAllocSettingStoreDO.masId).distinct()
                .from(scpAllocSettingStoreDO)
                .where(scpAllocSettingStoreDO.storeCode.in(storeCodes));
        if(CollectionUtils.isNotEmpty(masIds)){
            where.where(scpAllocSettingStoreDO.masId.in(masIds));
        }
        return where.fetch();
    }

    public List<ScpAllocSettingStoreRespVO> findByParam(ScpAllocSettingStoreParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(ScpAllocSettingStoreRespVO.class,
                        scpAllocSettingStoreDO.id,
                        scpAllocSettingStoreDO.masId,
                        scpAllocSettingStoreDO.storeId,
                        scpAllocSettingStoreDO.storeCode,
                        scpAllocSettingStoreDO.storeName,
                        scpAllocSettingStoreDO.storeType2,
                        scpAllocSettingStoreDO.maxNum,
                        scpAllocSettingStoreDO.allocNum
                ))
                .from(scpAllocSettingStoreDO);
        jpaQuery.where(scpAllocSettingStoreDO.masId.in(paramVO.getMasIds()));
        if (StrUtil.isNotBlank(paramVO.getStoreCode())) {
            jpaQuery.where(scpAllocSettingStoreDO.storeCode.eq(paramVO.getStoreCode()));
        }
        if (paramVO.getUsed() != null && paramVO.getUsed()) {
            jpaQuery.where(scpAllocSettingStoreDO.allocNum.gt(BigDecimal.ZERO));
        }
        return jpaQuery.fetch();
    }

    public List<ScpAllocSettingStoreRespVO> findEnabledByParam(ScpAllocSettingStoreParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(ScpAllocSettingStoreRespVO.class,
                        scpAllocSettingStoreDO.id,
                        scpAllocSettingStoreDO.masId,
                        scpAllocSettingStoreDO.storeId,
                        scpAllocSettingStoreDO.storeCode,
                        scpAllocSettingStoreDO.storeName
                ))
                .from(scpAllocSettingStoreDO)
                .leftJoin(scpAllocSettingDO).on(scpAllocSettingStoreDO.masId.eq(scpAllocSettingDO.id));
        if (CollUtil.isNotEmpty(paramVO.getMasIds())) {
            jpaQuery.where(scpAllocSettingStoreDO.masId.in(paramVO.getMasIds()));
        }
        if (CollUtil.isNotEmpty(paramVO.getStoreCodes())) {
            jpaQuery.where(scpAllocSettingStoreDO.storeCode.in(paramVO.getStoreCodes()));
        }
        jpaQuery.where(scpAllocSettingDO.status.eq(Boolean.TRUE));
        LocalDateTime startOfDay = LocalDateTime.now().toLocalDate().atStartOfDay();
        jpaQuery.where(scpAllocSettingDO.validTo.goe(startOfDay));
        return jpaQuery.fetch();
    }

    public List<Long> findUsedSettingByMasIds(List<Long> masIds) {
        var jpaQuery = jpaQueryFactory.select(scpAllocSettingStoreDO.masId).distinct()
                .from(scpAllocSettingStoreDO);
        jpaQuery.where(scpAllocSettingStoreDO.masId.in(masIds));
        jpaQuery.where(scpAllocSettingStoreDO.allocNum.gt(0));
        return jpaQuery.fetch();
    }
}
