package com.elitesland.scp.job.service;

import com.elitescloud.cloudt.system.service.SysSettingService;
import com.elitesland.scp.application.facade.vo.calendar.ScpCalendarStoreQueryParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetParamVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandSetSaveVO;
import com.elitesland.scp.application.service.calendar.ScpStoreDemandCalendarService;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.service.order.ScpDemandSetDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.order.ScpDemandSetDTO;
import com.elitesland.scp.rmi.RmiSysUserRpcService;
import com.elitesland.scp.utils.SysUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Optional;

@Slf4j
@Service
@RequiredArgsConstructor
public class ScpDemandSetJobServiceImpl implements ScpDemandSetJobService {

    private final RmiSysUserRpcService rmiSysUserRpcService;
    private final ScpDemandSetDomainService scpDemandSetDomainService;
    private final ScpStoreDemandCalendarService scpStoreDemandCalendarService;

    private final SysSettingService sysSettingService;

    @Override
    public void autoCreateDemandSet() {
        ScpCalendarStoreQueryParamVO paramVO = new ScpCalendarStoreQueryParamVO();
        paramVO.setWorkStatus(ScpUdcEnum.CALENDAR_WORK_STATUS_W.getValueCode());
        paramVO.setFindDate(LocalDate.now());
        Boolean isExist = scpStoreDemandCalendarService.isExistStoreByDateAndWorkStatus(paramVO);
        if (!isExist) {
            return;
        }
        // 保存订货集(门店+仓库)
        for (int i = 0; i < 7; i++) {
            LocalDate demandDate = LocalDate.now().plusDays(i);
            //查询是否存在订货集
            var scpDemandSetDTOList = scpDemandSetDomainService.findDemandSetByParam(ScpDemandSetParamVO.builder().demandDate(demandDate.atStartOfDay()).build());
            Optional<ScpDemandSetDTO> storeType = scpDemandSetDTOList.stream().filter(row -> ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType())).findAny();
//            Optional<ScpDemandSetDTO> whType = scpDemandSetDTOList.stream().filter(row -> ScpUdcEnum.DEMAND_SET_TYPE_1.getValueCode().equals(row.getType())).findAny();
            if (storeType.isEmpty()) {
                int times = SysUtils.getAutoOrderSetNumSetting();
                for(int n = 0; n < times; n++){
                    String storeDemandCode = rmiSysUserRpcService.sysNumberRuleGenerateCode(ScpConstant.BKST, new ArrayList<>());
                    saveDemandSet(demandDate.atStartOfDay(), storeDemandCode, ScpUdcEnum.DEMAND_SET_TYPE_0, ScpConstant.MDDHJ);
                }
            }

            // 爷爷茶不需要生成仓库的订货集，所以注释之
//            if (whType.isEmpty()) {
//                int times = SysUtils.getAutoOrderSetNumSetting();
//                for(int n = 0; n < times; n++){
//                    String whDemandCode = rmiSysUserRpcService.sysNumberRuleGenerateCode(ScpConstant.BKWH, new ArrayList<>());
//                    saveDemandSet(demandDate.atStartOfDay(), whDemandCode, ScpUdcEnum.DEMAND_SET_TYPE_1, ScpConstant.CKDHJ);
//                }
//            }
        }
    }

    /**
     * 保存订货集
     *
     * @param demandCode   需求编码
     * @param demandType   需求类型
     * @param demandPrefix 需求前缀
     */
    private void saveDemandSet(LocalDateTime demandDate, String demandCode, ScpUdcEnum demandType, String demandPrefix) {
        ScpDemandSetSaveVO demandSetSaveVO = new ScpDemandSetSaveVO();
        demandSetSaveVO.setDemandCode(demandCode);
        demandSetSaveVO.setType(demandType.getValueCode());
        demandSetSaveVO.setDemandName(demandPrefix + convertDate(demandDate) + demandCode.substring(demandCode.length() - 3));
        demandSetSaveVO.setDemandDate(demandDate);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        demandSetSaveVO.setExpireTime(LocalDateTime.of(demandDate.toLocalDate(), LocalTime.parse("13:00:00", formatter)));
        scpDemandSetDomainService.saveDemandSet(demandSetSaveVO);
    }

    /**
     * 格式化日期
     *
     * @return
     */
    private String convertDate(LocalDateTime demandDate) {
        // 定义日期格式
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy年M月d号");
        // 格式化日期
        return demandDate.format(formatter);
    }
}
