package com.elitesland.scp.application.facade.vo.resp.minOrder;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel("订货强配详情返回")
public class ScpMinOrderSettingStoreRespVO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = -7429845441661010333L;

    @ApiModelProperty("活动ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    @ApiModelProperty("门店ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long storeId;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty("经营类型")
    @SysCode(sys = "yst-supp", mod = "STORE_TYPE2")
    private String storeType2;
    private String storeType2Name;

    @ApiModelProperty("最大强配次数")
    private Integer maxNum;

    @ApiModelProperty("已配次数")
    private Integer activeNum;

    @ApiModelProperty(value = "区域")
    private String region;
    private String regionName;
}
