package com.elitesland.scp.application.service.mrp;


import com.elitesland.scp.application.facade.vo.param.mrp.ScpThousandUseRefParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpThousandUseRefVO;
import com.elitesland.scp.domain.convert.mrp.ScpThousandUseRefConvert;
import com.elitesland.scp.domain.entity.mrp.ScpThousandUseRefDO;
import com.elitesland.scp.infr.repo.mrp.ScpThousandUseRefRepo;
import com.elitesland.scp.infr.repo.mrp.ScpThousandUseRefRepoProc;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.Assert;

import java.util.*;

/**
 * 千元用量商品关联
 *
 * @author wangly
 * @date 2025-03-29
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ScpThousandUseRefServiceImpl extends BaseServiceImpl implements ScpThousandUseRefService {

    private final ScpThousandUseRefRepo scpThousandUseRefRepo;
    private final ScpThousandUseRefRepoProc scpThousandUseRefRepoProc;

    @Override
    public PagingVO<ScpThousandUseRefVO> queryPaging(ScpThousandUseRefParam param){
        return scpThousandUseRefRepoProc.queryPaging(param);
    }

    @Override
    public List<ScpThousandUseRefVO> queryListDynamic(ScpThousandUseRefParam param){
        return scpThousandUseRefRepoProc.queryListDynamic(param);
    }

    @Override
    public ScpThousandUseRefVO queryByKey(Long key) {
        ScpThousandUseRefDO entity = scpThousandUseRefRepo.findById(key).orElseGet(ScpThousandUseRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ScpThousandUseRefVO vo = ScpThousandUseRefConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ScpThousandUseRefVO insert(ScpThousandUseRefParam param) {
        ScpThousandUseRefDO entityDo = ScpThousandUseRefConvert.INSTANCE.toDo(param);
        return ScpThousandUseRefConvert.INSTANCE.toVo(scpThousandUseRefRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ScpThousandUseRefVO update(ScpThousandUseRefParam param) {
        ScpThousandUseRefDO entity = scpThousandUseRefRepo.findById(param.getId()).orElseGet(ScpThousandUseRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ScpThousandUseRefDO entityDo = ScpThousandUseRefConvert.INSTANCE.toDo(param);
        entity.copy(entityDo);
        return ScpThousandUseRefConvert.INSTANCE.toVo(scpThousandUseRefRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(ScpThousandUseRefParam payload) {
        ScpThousandUseRefDO entity = scpThousandUseRefRepo.findById(payload.getId()).orElseGet(ScpThousandUseRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = scpThousandUseRefRepoProc.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            scpThousandUseRefRepoProc.deleteSoft(keys);
        }
    }

}
