package com.elitesland.scp.application.service.order;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderAddItemParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderDPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderDelParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDMgmtRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDPriceRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDMgmtSaveVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDPriceSaveVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSaveVO;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDO;

import java.util.List;

public interface ScpDemandOrderDService {

    /**
     * 根据订货订单ID查询明细信息
     *
     * @param masId
     * @return
     */
    List<ScpDemandOrderDMgmtRespVO> findDemandOrderDByMasId(Long masId);

    /**
     * 分页展示行数据
     *
     * @param paramVO
     * @return
     */
    PagingVO<ScpDemandOrderDRespVO> pageDemandOrderDByMasId(ScpDemandOrderDPageParamVO paramVO);

    /**
     * 删除
     *
     * @param id
     */
    void remove(Long id);

    /**
     * 订货订单明细保存-管理端
     *
     * @param masId
     * @param saveVOS
     */
    void batchSaveDemandOrderDMgmt(Long masId, String storeId, List<ScpDemandOrderDMgmtSaveVO> saveVOS, String source);


    ScpDemandOrderDPriceRespVO updatePrice(ScpDemandOrderDPriceSaveVO scpDemandOrderDPriceSaveVO);

    /**
     * 订货订单明细保存
     *
     * @param masId
     * @param source
     * @param saveVOS
     * @return
     */
    void batchSaveDemandOrderD(Long masId, String source, List<ScpDemandOrderDSaveVO> saveVOS);

    default void batchSaveDemandOrderD(Long masId, List<ScpDemandOrderDSaveVO> saveVOS, String source) {
        batchSaveDemandOrderD(masId, source, saveVOS);
    }

    /**
     * 订货行保存
     *
     * @param scpDemandOrderDSaveVO
     */
    void saveDemandOrderD(ScpDemandOrderDSaveVO scpDemandOrderDSaveVO);

    /**
     * 订单订单明细删除-删除父级ID一样的数据
     *
     * @param paramVO
     */
    void deleteByParam(ScpDemandOrderDelParamVO paramVO);

    /**
     * 追加商品
     *
     * @param masId
     * @param saveVOS
     */
    void addItem(Long masId, List<ScpDemandOrderAddItemParamVO> saveVOS);

    /**
     * 根据来源单据ID查询明细
     *
     * @param srcDocId
     * @return
     */
    List<ScpDemandOrderDRespVO> findDemandOrderDBySrcDocId(Long srcDocId);

    ScpDemandOrderDO submitDemandOrder(Long masId, List<ScpDemandOrderDMgmtSaveVO> saveVOS);
}
