package com.elitesland.scp.infr.repo.item;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.zhxu.bs.util.StringUtils;
import com.elitesland.scp.application.facade.vo.param.app.AppItemPageParamVO;
import com.elitesland.scp.application.facade.vo.param.app.CommonItemPageParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemHotParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItmItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemRespVO;
import com.elitesland.scp.domain.entity.item.QScpCateItemDO;
import com.elitesland.scp.domain.entity.item.QScpCateItemSaleScopeStoreDO;
import com.elitesland.scp.domain.entity.whnet.QScpWhNetRelationDO;
import com.elitesland.scp.dto.item.ScpCateItemDTO;
import com.elitesland.scp.param.CateItemRpcParam;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @description: TODO
 * @author: huruizhong
 * @modified By: huruizhong
 * @date: Created in 2024/4/3 4:04 下午
 * @version:v1.0
 */
@Slf4j
@Component
@RequiredArgsConstructor
public class ScpCateItemRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QScpCateItemDO scpCateItemDO = QScpCateItemDO.scpCateItemDO;
    private final QScpCateItemSaleScopeStoreDO scpCateItemSaleScopeStoreDO = QScpCateItemSaleScopeStoreDO.scpCateItemSaleScopeStoreDO;


    public List<String> queryByItemCodes(List<String> itemCodes) {
        var jpaQuery = jpaQueryFactory.select(scpCateItemDO.itemCode)
                .from(scpCateItemDO)
                .where(scpCateItemDO.itemCode.in(itemCodes));
        return jpaQuery.fetch();
    }

    public List<String> queryItemCode(CateItemRpcParam paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpCateItemDO.itemCode)
                .from(scpCateItemDO);

        List<Predicate> predicates = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(paramVO.getCateCodes())) {
            predicates.add(scpCateItemDO.cateCode.in(paramVO.getCateCodes()));
        }
        if (CollectionUtils.isNotEmpty(paramVO.getCateIds())) {
            predicates.add(scpCateItemDO.cateId.in(paramVO.getCateIds()));
        }
        if (CollectionUtils.isNotEmpty(paramVO.getItemCodes())) {
            predicates.add(scpCateItemDO.itemCode.in(paramVO.getItemCodes()));
        }
        if (CollectionUtils.isNotEmpty(paramVO.getItemIds())) {
            predicates.add(scpCateItemDO.itemId.in(paramVO.getItemIds()));
        }

        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetch();
    }


    public List<ScpCateItemDTO> queryDto(CateItemRpcParam paramVO) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(ScpCateItemDTO.class,
                        scpCateItemDO.cateId,
                        scpCateItemDO.cateCode,
                        scpCateItemDO.itemCode,
                        scpCateItemDO.itemName,
                        scpCateItemDO.itemId,
                        scpCateItemDO.hotFlag,
                        scpCateItemDO.combineItemFlag))
                .from(scpCateItemDO);
        List<Predicate> predicates = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(paramVO.getCateCodes())) {
            predicates.add(scpCateItemDO.cateCode.in(paramVO.getCateCodes()));
        }
        if (CollectionUtils.isNotEmpty(paramVO.getCateIds())) {
            predicates.add(scpCateItemDO.cateId.in(paramVO.getCateIds()));
        }
        if (CollectionUtils.isNotEmpty(paramVO.getItemCodes())) {
            predicates.add(scpCateItemDO.itemCode.in(paramVO.getItemCodes()));
        }
        if (CollectionUtils.isNotEmpty(paramVO.getItemIds())) {
            predicates.add(scpCateItemDO.itemId.in(paramVO.getItemIds()));
        }
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetch();
    }

    public Long countAppItemSpu(AppItemPageParamVO param) {
        var jpaQuery = jpaQueryFactory.select(scpCateItemDO.count()).from(scpCateItemDO);
        if (param != null) {
            jpaQuery.where(getPredicates(param));
        }
        jpaQuery.orderBy(scpCateItemDO.spuId.desc());
        jpaQuery.groupBy(scpCateItemDO.spuId);
        return jpaQuery.fetchCount();
    }

    public Long countAppItemSku(AppItemPageParamVO param) {
        var jpaQuery = jpaQueryFactory.select(scpCateItemDO.count()).from(scpCateItemDO);
        if (param != null) {
            jpaQuery.where(getPredicates(param));
        }
        jpaQuery.orderBy(scpCateItemDO.itemId.desc());
        jpaQuery.groupBy(scpCateItemDO.itemId);
        return jpaQuery.fetchCount();
    }

    public List<AppItmItemPageVO> pageAppItemSpu(AppItemPageParamVO param) {
        JPAQuery<AppItmItemPageVO> jpaQuery = jpaQueryFactory.select(Projections.bean(AppItmItemPageVO.class,
                scpCateItemDO.cateCode.as("itemCateCode"),
                scpCateItemDO.cateId,
                scpCateItemDO.spuId,
                scpCateItemDO.spuName,
                scpCateItemDO.spuCode,
                scpCateItemDO.sortNo,
                scpCateItemDO.itemType2,
                scpCateItemDO.combineItemFlag
        )).distinct().from(scpCateItemDO);
        if (param != null) {
            jpaQuery.where(getPredicates(param));
        }
        param.setPaging(jpaQuery);
        jpaQuery.orderBy(scpCateItemDO.sortNo.desc());
        jpaQuery.groupBy(scpCateItemDO.cateCode,
                scpCateItemDO.cateId,
                scpCateItemDO.spuId,
                scpCateItemDO.spuName,
                scpCateItemDO.spuCode,
                scpCateItemDO.sortNo,
                scpCateItemDO.itemType2,
                scpCateItemDO.combineItemFlag);
        return jpaQuery.fetch();
    }

    public List<AppItmItemPageVO> pageAppItemSku(AppItemPageParamVO param) {
        JPAQuery<AppItmItemPageVO> jpaQuery = jpaQueryFactory.select(Projections.bean(AppItmItemPageVO.class,
                scpCateItemDO.cateCode.as("itemCateCode"),
                scpCateItemDO.cateId,
                scpCateItemDO.spuId,
                scpCateItemDO.spuName,
                scpCateItemDO.spuCode,
                scpCateItemDO.itemCode,
                scpCateItemDO.itemType2,
                scpCateItemDO.itemId,
                scpCateItemDO.sortNo
        )).distinct().from(scpCateItemDO);
        if (param != null) {
            jpaQuery.where(getPredicates(param));
        }
        param.setPaging(jpaQuery);
        jpaQuery.orderBy(scpCateItemDO.sortNo.desc());
        jpaQuery.groupBy(scpCateItemDO.cateCode,
                scpCateItemDO.cateId,
                scpCateItemDO.spuId,
                scpCateItemDO.spuName,
                scpCateItemDO.spuCode,
                scpCateItemDO.itemCode,
                scpCateItemDO.itemType2,
                scpCateItemDO.itemId,
                scpCateItemDO.sortNo);
        return jpaQuery.fetch();
    }

    public Long countAppItemAndWhNetSku(AppItemPageParamVO param) {
        QScpWhNetRelationDO scpWhNetRelationDO = QScpWhNetRelationDO.scpWhNetRelationDO;
        var jpaQuery = jpaQueryFactory.select(scpCateItemDO.count())
                .from(scpCateItemDO)
                .leftJoin(scpWhNetRelationDO)
                .on(scpCateItemDO.itemId.eq(scpWhNetRelationDO.itemId));
        if (param != null) {
            jpaQuery.where(getPredicatesWithItemDo(param));
            if (CollUtil.isNotEmpty(param.getDeliveryTypes())) {
                jpaQuery.where((scpWhNetRelationDO.id.isNotNull().and(scpWhNetRelationDO.deliveryType.in(param.getDeliveryTypes())))
                        .or(scpWhNetRelationDO.id.isNull().and(scpCateItemDO.itemType2.in(param.getDeliveryTypes()))));
            }
        }
        jpaQuery.orderBy(scpCateItemDO.itemId.desc());
        jpaQuery.groupBy(scpCateItemDO.itemId);
        return jpaQuery.fetchCount();
    }

    public List<AppItmItemPageVO> pageAppItemAndWhNetSku(AppItemPageParamVO param) {
        QScpWhNetRelationDO scpWhNetRelationDO = QScpWhNetRelationDO.scpWhNetRelationDO;
        JPAQuery<AppItmItemPageVO> jpaQuery = jpaQueryFactory.select(Projections.bean(AppItmItemPageVO.class,
                scpCateItemDO.cateCode.as("itemCateCode"),
                scpCateItemDO.cateId,
                scpCateItemDO.spuId,
                scpCateItemDO.spuName,
                scpCateItemDO.spuCode,
                scpCateItemDO.firstLetter,
                scpCateItemDO.itemCode,
                scpCateItemDO.itemId,
                scpCateItemDO.sortNo,
                // 使用 CASE WHEN 语法
                Expressions.cases()
                        .when(scpWhNetRelationDO.deliveryType.isNull()).then(scpCateItemDO.itemType2)
                        .otherwise(scpWhNetRelationDO.deliveryType).as("itemType2"),
                scpCateItemDO.combineItemFlag
                )).distinct().from(scpCateItemDO)
                .leftJoin(scpWhNetRelationDO).on(scpCateItemDO.itemId.eq(scpWhNetRelationDO.itemId)
                        .and(scpWhNetRelationDO.demandWhStCode.eq(param.getStoreCode())));
        if (param != null) {
            jpaQuery.where(getPredicatesWithItemDo(param));
            if (CollUtil.isNotEmpty(param.getDeliveryTypes())) {
                jpaQuery.where((scpWhNetRelationDO.id.isNotNull().and(scpWhNetRelationDO.deliveryType.in(param.getDeliveryTypes())))
                        .or(scpWhNetRelationDO.id.isNull().and(scpCateItemDO.itemType2.in(param.getDeliveryTypes()))));
            }
        }
        jpaQuery.orderBy(scpCateItemDO.sortNo.desc());
        jpaQuery.groupBy(scpCateItemDO.cateCode,
                scpCateItemDO.cateId,
                scpCateItemDO.spuId,
                scpCateItemDO.spuName,
                scpCateItemDO.spuCode,
                scpCateItemDO.itemCode,
                scpCateItemDO.itemId,
                scpCateItemDO.sortNo,
                scpCateItemDO.itemType2,
                scpCateItemDO.combineItemFlag);
        return jpaQuery.fetch();
    }

    public List<String> pageItemCodesByParam(List<Long> spuIds) {
        JPAQuery<String> jpaQuery = jpaQueryFactory.select(scpCateItemDO.itemCode).from(scpCateItemDO);
        jpaQuery.where(scpCateItemDO.spuId.in(spuIds));
        return jpaQuery.fetch();
    }

    public long countItem(ScpCateItemPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpCateItemDO.count())
                .from(scpCateItemDO);
        jpaQuery.where(this.whereItemPage(paramVO));
        return jpaQuery.fetchCount();
    }

    private Predicate whereItemPage(ScpCateItemPageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (paramVO.getHotFlag() != null) {
            predicates.add(scpCateItemDO.hotFlag.eq(paramVO.getHotFlag()));
        }
        if (StrUtil.isNotBlank(paramVO.getItemType())) {
            predicates.add(scpCateItemDO.itemType.eq(paramVO.getItemType()));
        }
        if (StrUtil.isNotBlank(paramVO.getItemType2())) {
            predicates.add(scpCateItemDO.itemType2.eq(paramVO.getItemType2()));
        }
        if (StrUtil.isNotBlank(paramVO.getItemName())) {
            predicates.add(scpCateItemDO.itemName.like("%" + paramVO.getItemName() + "%"));
        }
        if (StrUtil.isNotBlank(paramVO.getItemCode())) {
            predicates.add(scpCateItemDO.itemCode.like("%" + paramVO.getItemCode() + "%"));
        }
        if (CollUtil.isNotEmpty(paramVO.getScpCateCodes())) {
            predicates.add(scpCateItemDO.cateCode.in(paramVO.getScpCateCodes()));
        }
        if (Objects.nonNull(paramVO.getSaleStatus())) {
            predicates.add(scpCateItemDO.saleStatus.eq(paramVO.getSaleStatus()));
        }
        if (Objects.nonNull(paramVO.getUpDownStatus())) {
            predicates.add(scpCateItemDO.upDownStatus.eq(paramVO.getUpDownStatus()));
        }
        if (Objects.nonNull(paramVO.getVisibleStatus())) {
            predicates.add(scpCateItemDO.visibleStatus.eq(paramVO.getVisibleStatus()));
        }
        if (Objects.nonNull(paramVO.getPreSaleStatus())) {
            predicates.add(scpCateItemDO.preSaleStatus.eq(paramVO.getPreSaleStatus()));
        }
        if (CollUtil.isNotEmpty(paramVO.getItemIds())) {
            predicates.add(scpCateItemDO.itemId.in(paramVO.getItemIds()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<ScpCateItemRespVO> queryItemList(ScpCateItemPageParamVO param) {
        JPAQuery<ScpCateItemRespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(ScpCateItemRespVO.class,
                scpCateItemDO.id,
                scpCateItemDO.itemId,
                scpCateItemDO.itemCode,
                scpCateItemDO.itemName,
                scpCateItemDO.itemType,
                scpCateItemDO.itemType2,
                scpCateItemDO.combineItemFlag
        )).distinct().from(scpCateItemDO);
        if (param != null) {
            jpaQuery.where(whereItemPage(param));
        }
        return jpaQuery.fetch();
    }

    public List<ScpCateItemPageVO> skuPage(ScpCateItemPageParamVO param) {
        JPAQuery<ScpCateItemPageVO> jpaQuery = jpaQueryFactory.select(Projections.bean(ScpCateItemPageVO.class,
                scpCateItemDO.id,
                scpCateItemDO.id.as("scpCateItemId"),
                scpCateItemDO.itemId,
                scpCateItemDO.itemCode,
                scpCateItemDO.itemName,
                scpCateItemDO.cateCode.as("scpCateCode"),
                scpCateItemDO.cateId.as("scpCateId"),
                scpCateItemDO.hotFlag,
                scpCateItemDO.sortNo,
                scpCateItemDO.saleStatus,
                scpCateItemDO.upDownStatus,
                scpCateItemDO.visibleStatus,
                scpCateItemDO.preSaleStatus,
                scpCateItemDO.combineItemFlag,
                scpCateItemDO.itemType2
        )).from(scpCateItemDO);
        if (param != null) {
            jpaQuery.where(whereItemPage(param));
        }
        jpaQuery.orderBy(scpCateItemDO.sortNo.desc());
        return jpaQuery.fetch();
    }


    public Predicate getPredicates(AppItemPageParamVO paramVO) {
        List<Predicate> list = new ArrayList<>();
        list.add(scpCateItemDO.deleteFlag.eq(0));
        if (CollectionUtils.isNotEmpty(paramVO.getItemCateCodes())) {
            list.add(scpCateItemDO.cateCode.in(paramVO.getItemCateCodes()));
        }
        if (StringUtils.isNotBlank(paramVO.getKeyword())) {
            list.add(scpCateItemDO.itemCode.contains(paramVO.getKeyword())
                    .or(scpCateItemDO.itemName.contains(paramVO.getKeyword()))
                    .or(scpCateItemDO.spuCode.contains(paramVO.getKeyword()))
                    .or(scpCateItemDO.spuName.contains(paramVO.getKeyword()))
                    .or(scpCateItemDO.anotherName.contains(paramVO.getKeyword())));
        }
        if (CollectionUtils.isNotEmpty(paramVO.getItemIds())) {
            list.add(scpCateItemDO.itemId.in(paramVO.getItemIds()));
        }
        if (ObjectUtils.isNotEmpty(paramVO.getSpuId())) {
            list.add(scpCateItemDO.spuId.eq(paramVO.getSpuId()));
        }
        if (CollUtil.isNotEmpty(paramVO.getItemTypes())) {
            list.add(scpCateItemDO.itemType.in(paramVO.getItemTypes()));
        }
        if (StrUtil.isNotBlank(paramVO.getBrand())) {
            list.add(scpCateItemDO.brand.like("%" + paramVO.getBrand() + "%"));
        }
        return ExpressionUtils.allOf(list);
    }

    public Predicate getPredicatesWithItemDo(AppItemPageParamVO paramVO) {
        List<Predicate> list = new ArrayList<>();
        list.add(scpCateItemDO.deleteFlag.eq(0));
        if (CollectionUtils.isNotEmpty(paramVO.getItemCateCodes())) {
            list.add(scpCateItemDO.cateCode.in(paramVO.getItemCateCodes()));
        }
        if (StringUtils.isNotBlank(paramVO.getKeyword())) {
            list.add(scpCateItemDO.itemCode.contains(paramVO.getKeyword())
                    .or(scpCateItemDO.itemName.contains(paramVO.getKeyword()))
                    .or(scpCateItemDO.spuCode.contains(paramVO.getKeyword()))
                    .or(scpCateItemDO.spuName.contains(paramVO.getKeyword()))
                    .or(scpCateItemDO.anotherName.contains(paramVO.getKeyword()))
                    .or(scpCateItemDO.firstLetter.contains(paramVO.getKeyword())));
        }
        if (CollectionUtils.isNotEmpty(paramVO.getItemIds())) {
            list.add(scpCateItemDO.itemId.in(paramVO.getItemIds()));
        }
        if (ObjectUtils.isNotEmpty(paramVO.getSpuId())) {
            list.add(scpCateItemDO.spuId.eq(paramVO.getSpuId()));
        }
        if (CollUtil.isNotEmpty(paramVO.getItemTypes())) {
            list.add(scpCateItemDO.itemType.in(paramVO.getItemTypes()));
        }
        if (CollUtil.isNotEmpty(paramVO.getItemCodes())) {
            list.add(scpCateItemDO.itemCode.in(paramVO.getItemCodes()));
        }
        if (StrUtil.isNotBlank(paramVO.getBrand())) {
            list.add(scpCateItemDO.brand.like("%" + paramVO.getBrand() + "%"));
        }
        return ExpressionUtils.allOf(list);
    }

    public Long changeHotFlag(ScpCateItemHotParamVO paramVO) {
        return jpaQueryFactory.update(scpCateItemDO)
                .set(scpCateItemDO.hotFlag, paramVO.getHotFlag())
                .where(scpCateItemDO.id.in(paramVO.getItemIds()))
                .execute();
    }

    public void updateItemSpuInfo(String itemType2, String anotherName, Long spuId) {
        var update = jpaQueryFactory.update(scpCateItemDO);
        update.set(scpCateItemDO.itemType, itemType2);
        update.set(scpCateItemDO.anotherName, anotherName);
        update.where(scpCateItemDO.spuId.eq(spuId));
        update.execute();
    }

    public void updateItemBrand(String brand, Long rootCateId) {
        var update = jpaQueryFactory.update(scpCateItemDO);
        if (StrUtil.isNotBlank(brand)) {
            update.set(scpCateItemDO.brand, brand);
        }
        update.where(scpCateItemDO.rootCateId.eq(rootCateId));
        update.execute();
    }

    public List<String> getFirstCateByType(List<String> itemTypes, List<String> brands) {
        var jpaQuery = jpaQueryFactory.select(scpCateItemDO.cateCode).from(scpCateItemDO)
                .where(scpCateItemDO.itemType.in(itemTypes).and(scpCateItemDO.brand.in(brands)));
        return jpaQuery.fetch();
    }

    public Long countCommonItemSpu(CommonItemPageParamVO param) {
        var jpaQuery = jpaQueryFactory.select(scpCateItemDO.count()).from(scpCateItemDO);
        if (param != null) {
            jpaQuery.where(getCommonPredicates(param));
        }
        jpaQuery.orderBy(scpCateItemDO.spuId.desc());
        jpaQuery.groupBy(scpCateItemDO.spuId);
        return jpaQuery.fetchCount();
    }

    public List<AppItmItemPageVO> pageCommonItemSpu(CommonItemPageParamVO param) {
        JPAQuery<AppItmItemPageVO> jpaQuery = jpaQueryFactory.select(Projections.bean(AppItmItemPageVO.class,
                scpCateItemDO.cateCode.as("itemCateCode"),
                scpCateItemDO.cateId,
                scpCateItemDO.spuId,
                scpCateItemDO.spuName,
                scpCateItemDO.spuCode,
                scpCateItemDO.combineItemFlag
        )).distinct().from(scpCateItemDO);
        if (param != null) {
            jpaQuery.where(getCommonPredicates(param));
        }
        param.setPaging(jpaQuery);
        jpaQuery.orderBy(scpCateItemDO.spuId.desc());
        jpaQuery.groupBy(scpCateItemDO.cateCode,
                scpCateItemDO.cateId,
                scpCateItemDO.spuId,
                scpCateItemDO.spuName,
                scpCateItemDO.spuCode,
                scpCateItemDO.combineItemFlag);
        return jpaQuery.fetch();
    }


    public Predicate getCommonPredicates(CommonItemPageParamVO paramVO) {
        List<Predicate> list = new ArrayList<>();
        list.add(scpCateItemDO.deleteFlag.eq(0));
        if (CollectionUtils.isNotEmpty(paramVO.getItemCateCodes())) {
            list.add(scpCateItemDO.cateCode.in(paramVO.getItemCateCodes()));
        }
        if (StringUtils.isNotBlank(paramVO.getKeyword())) {
            list.add(scpCateItemDO.itemCode.contains(paramVO.getKeyword())
                    .or(scpCateItemDO.itemName.contains(paramVO.getKeyword()))
                    .or(scpCateItemDO.spuCode.contains(paramVO.getKeyword()))
                    .or(scpCateItemDO.spuName.contains(paramVO.getKeyword()))
                    .or(scpCateItemDO.anotherName.contains(paramVO.getKeyword())));
        }
        if (CollectionUtils.isNotEmpty(paramVO.getItemIds())) {
            list.add(scpCateItemDO.itemId.in(paramVO.getItemIds()));
        }
        if (ObjectUtils.isNotEmpty(paramVO.getSpuId())) {
            list.add(scpCateItemDO.spuId.eq(paramVO.getSpuId()));
        }
        if (CollUtil.isNotEmpty(paramVO.getItemTypes())) {
            list.add(scpCateItemDO.itemType.in(paramVO.getItemTypes()));
        }
        if (StrUtil.isNotBlank(paramVO.getBrand())) {
            list.add(scpCateItemDO.brand.like("%" + paramVO.getBrand() + "%"));
        }
        return ExpressionUtils.allOf(list);
    }

    public List<Long> appItemSku(AppItemPageParamVO param) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(scpCateItemDO.itemId).distinct().from(scpCateItemDO);
        if (param != null) {
            jpaQuery.where(getPredicates(param));
        }
        return jpaQuery.fetch();
    }

    @Transactional(rollbackFor = Exception.class)
    public void updateItemNameByItemId(String itemName, Long itemId) {
        var update = jpaQueryFactory.update(scpCateItemDO);
        update.set(scpCateItemDO.itemName, itemName);
        update.where(scpCateItemDO.itemId.eq(itemId));
        update.execute();
    }

    @Transactional(rollbackFor = Exception.class)
    public void updateSortNoById(Integer sortNo, Long id) {
        var update = jpaQueryFactory.update(scpCateItemDO);
        update.set(scpCateItemDO.sortNo, sortNo);
        update.where(scpCateItemDO.id.eq(id));
        update.execute();
    }

    @Transactional(rollbackFor = Exception.class)
    public void updateItemType2(String itemCode, String itemType2) {
        var update = jpaQueryFactory.update(scpCateItemDO);
        update.set(scpCateItemDO.itemType2, itemType2);
        update.set(scpCateItemDO.modifyTime, LocalDateTime.now());
        update.where(scpCateItemDO.itemCode.eq(itemCode));
        update.execute();
    }

    //  获取可售可见已上架的商品
    public List<String> getVisibleAndSaleAndUpItemList(List<String> itemCodeList, String storeCode) {
        LocalDateTime localDateTime = LocalDateTime.now();
        JPAQuery<String> jpaQuery = jpaQueryFactory.select(scpCateItemDO.itemCode)
                .from(scpCateItemDO)
                .leftJoin(scpCateItemSaleScopeStoreDO)
                .on(scpCateItemDO.id.eq(scpCateItemSaleScopeStoreDO.masId))
                .where(scpCateItemDO.itemCode.in(itemCodeList)
                        .and(scpCateItemSaleScopeStoreDO.storeCode.eq(storeCode))
                        .and(scpCateItemDO.upDownStatus.eq(true))
                        .and(scpCateItemDO.saleStatus.eq(true))
                        .and(scpCateItemDO.saleDateStart.loe(localDateTime))
                        .and(scpCateItemDO.saleDateEnd.goe(localDateTime))
                        .and(scpCateItemSaleScopeStoreDO.visibleDateStart.isNull().or(scpCateItemSaleScopeStoreDO.visibleDateStart.goe(localDateTime)))// 早于可售开始时间
                        .and(scpCateItemSaleScopeStoreDO.visibleDateEnd.isNull().or(scpCateItemSaleScopeStoreDO.visibleDateEnd.loe(localDateTime)))); // 晚于可售结束时间
        return jpaQuery.fetch();
    }

    //获取可售已上架的商品
    public List<String> getSaleAndUpItemList(List<String> itemCodeList, String storeCode) {
        LocalDateTime localDateTime = LocalDateTime.now();
        JPAQuery<String> jpaQuery = jpaQueryFactory.select(scpCateItemDO.itemCode)
                .from(scpCateItemDO)
                .leftJoin(scpCateItemSaleScopeStoreDO)
                .on(scpCateItemDO.id.eq(scpCateItemSaleScopeStoreDO.masId))
                .where(scpCateItemDO.itemCode.in(itemCodeList)
                        .and(scpCateItemSaleScopeStoreDO.storeCode.eq(storeCode))
                        .and(scpCateItemDO.upDownStatus.eq(true))
                        .and(scpCateItemDO.saleStatus.eq(true))
                        .and(scpCateItemDO.saleDateStart.loe(localDateTime))
                        .and(scpCateItemDO.saleDateEnd.goe(localDateTime)));
        return jpaQuery.fetch();
    }
    // 获取预售商品
    public List<String> getPreSaleItemList(List<String> itemCodeList) {
        JPAQuery<String> jpaQuery = jpaQueryFactory.select(scpCateItemDO.itemCode)
                .from(scpCateItemDO)
                .where(scpCateItemDO.itemCode.in(itemCodeList)
                        .and(scpCateItemDO.preSaleStatus.eq(true))
                );
        return jpaQuery.fetch();
    }
}
