package com.elitesland.scp.utils.excel;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * DchExcelImportVO
 * </p >
 *
 * @author niu.chen
 * @date 2020/7/13
 */
@Data
public class DchExcelImportVO implements Serializable {

    private static final long serialVersionUID = 3200542956194801339L;
    @ApiModelProperty("Excel文件名")
    String fileName;

    @ApiModelProperty("表名")
    String tableName;
    @ApiModelProperty("导入类型")
    String type;
  //  @ApiModelProperty("字段类型,字段名, 字段中文说明")
 //   List<DchExcelTableVO> dchExcelTables=new ArrayList<>();
    @ApiModelProperty("按行存储的excel头信息,一条是一行.可以多行头")
    List<Map<Integer, String>> headMapList=new ArrayList<>();

    @ApiModelProperty("数据(字段名,数据)")
    List<Map<Integer,Object>> dataMapsList=new ArrayList<>();

    @ApiModelProperty("错误信息")
    List<String> errMsgList = new ArrayList<>();

}
