/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.purLimit;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.save.purLimit.ScpPurLimitSettingSaveVO;
import com.elitesland.scp.domain.convert.purLimit.ScpPurLimitSettingConvert;
import com.elitesland.scp.domain.entity.purLimit.ScpPurLimitSettingDO;
import com.elitesland.scp.domain.service.purLimit.ScpPurLimitSettingDomainService;
import com.elitesland.scp.infr.dto.purLimit.ScpPurLimitSettingDTO;
import com.elitesland.scp.infr.repo.purLimit.ScpPurLimitSettingRepo;
import com.elitesland.scp.infr.repo.purLimit.ScpPurLimitSettingRepoProc;
import com.elitesland.scp.infr.repo.purLimit.ScpPurLimitSettingStoreRepoProc;
import com.elitesland.scp.rmi.RmiSysUDCService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScpPurLimitSettingDomainServiceImpl
implements ScpPurLimitSettingDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpPurLimitSettingDomainServiceImpl.class);
    private final ScpPurLimitSettingRepo scpPurLimitSettingRepo;
    private final ScpPurLimitSettingRepoProc scpPurLimitSettingRepoProc;
    private final ScpPurLimitSettingStoreRepoProc scpPurLimitSettingStoreRepoProc;
    private final RmiSysUDCService rmiSysUDCService;

    @Override
    @SysCodeProc
    public PagingVO<ScpPurLimitSettingPageRespVO> queryPurLimitSettingList(ScpPurLimitSettingPageParamVO paramVO) {
        long count = this.scpPurLimitSettingRepoProc.countPurLimitSetting(paramVO);
        if (count > 0L) {
            Map<String, String> docTypeMap = this.rmiSysUDCService.getCodeMap("yst-suplan", "OB_DOC_TYPE");
            List<ScpPurLimitSettingPageRespVO> PurLimitSettings = this.scpPurLimitSettingRepoProc.queryPurLimitSetting(paramVO);
            Map<Long, Long> usedIdMap = this.getUsedIdMap(PurLimitSettings);
            PurLimitSettings.forEach(item -> {
                if (StrUtil.isNotBlank((CharSequence)item.getDocType())) {
                    List<String> itemCateName = StrUtil.split((CharSequence)item.getDocType(), (char)',').stream().map(docTypeMap::get).collect(Collectors.toList());
                    item.setDocTypeNames(itemCateName);
                }
                item.setUseFlag(usedIdMap.containsKey(item.getId()));
            });
            return new PagingVO(count, PurLimitSettings);
        }
        return new PagingVO();
    }

    private Map<Long, Long> getUsedIdMap(List<ScpPurLimitSettingPageRespVO> PurLimitSettings) {
        List<Long> ids = PurLimitSettings.stream().map(BaseViewModel::getId).collect(Collectors.toList());
        List<Long> usedSettings = this.scpPurLimitSettingStoreRepoProc.findUsedSettingByMasIds(ids);
        if (CollUtil.isNotEmpty(usedSettings)) {
            return usedSettings.stream().collect(Collectors.toMap(Long::valueOf, Function.identity()));
        }
        return new HashMap<Long, Long>();
    }

    @Override
    @SysCodeProc
    public Optional<ScpPurLimitSettingDTO> findPurLimitSettingById(Long id) {
        return this.scpPurLimitSettingRepo.findById(id).map(ScpPurLimitSettingConvert.INSTANCE::doToDto);
    }

    @Override
    public Long savePurLimitSetting(ScpPurLimitSettingSaveVO saveVO) {
        if (saveVO.getId() == null) {
            ScpPurLimitSettingDO intentDO = ScpPurLimitSettingConvert.INSTANCE.saveVoToDO(saveVO);
            intentDO.setDocType(StrUtil.join((CharSequence)",", saveVO.getDocTypes()));
            Long masId = ((ScpPurLimitSettingDO)this.scpPurLimitSettingRepo.save(intentDO)).getId();
            return masId;
        }
        Optional<ScpPurLimitSettingDO> option = this.scpPurLimitSettingRepo.findById(saveVO.getId());
        if (option.isEmpty()) {
            throw new BusinessException("\u8ba2\u8d27\u5f3a\u914d\u6d3b\u52a8ID\uff1a" + saveVO.getId() + "\u4e0d\u5b58\u5728");
        }
        ScpPurLimitSettingDO scpPurLimitSettingDO = option.get();
        ScpPurLimitSettingConvert.INSTANCE.copySaveParamToDo(saveVO, scpPurLimitSettingDO);
        scpPurLimitSettingDO.setDocType(StrUtil.join((CharSequence)",", saveVO.getDocTypes()));
        Long masId = ((ScpPurLimitSettingDO)this.scpPurLimitSettingRepo.save(scpPurLimitSettingDO)).getId();
        return masId;
    }

    @Override
    public void enablePurLimitSetting(List<Long> ids, Boolean enable) {
        this.scpPurLimitSettingRepoProc.enablePurLimitSetting(ids, enable);
    }

    @Override
    public void deleteByIds(List<Long> ids) {
        List<ScpPurLimitSettingDO> settingDOS = this.scpPurLimitSettingRepo.findByIdIn(ids);
        this.scpPurLimitSettingRepoProc.deleteByIds(ids);
    }

    public ScpPurLimitSettingDomainServiceImpl(ScpPurLimitSettingRepo scpPurLimitSettingRepo, ScpPurLimitSettingRepoProc scpPurLimitSettingRepoProc, ScpPurLimitSettingStoreRepoProc scpPurLimitSettingStoreRepoProc, RmiSysUDCService rmiSysUDCService) {
        this.scpPurLimitSettingRepo = scpPurLimitSettingRepo;
        this.scpPurLimitSettingRepoProc = scpPurLimitSettingRepoProc;
        this.scpPurLimitSettingStoreRepoProc = scpPurLimitSettingStoreRepoProc;
        this.rmiSysUDCService = rmiSysUDCService;
    }
}

