package com.elitesland.scp.application.service.app;

import com.elitesland.scp.application.facade.vo.param.app.AppStoreServiceEntityRespVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigRespVO;
import com.elitesland.scp.application.service.serviceconfig.ScpServiceConfigService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 09月 17日 19:13
 * @version: 1.0
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class AppStoreServiceEntityServiceImpl implements AppStoreServiceEntityService {

    private final OrgStoreRpcService orgStoreRpcService;

    private final ScpServiceConfigService scpServiceConfigService;

    private final OrgOuRpcService orgOuRpcService;
    @Override
    public AppStoreServiceEntityRespVO query(String storeCode) {
        AppStoreServiceEntityRespVO entityRespVO = new AppStoreServiceEntityRespVO();
        entityRespVO.setStoreCode(storeCode);
        OrgStoreBaseRpcParam baseRpcParam = new OrgStoreBaseRpcParam();
        baseRpcParam.setStoreCode(storeCode);
        OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = orgStoreRpcService
                .findSimpleStoreByParam(baseRpcParam)
                .computeData().get(0);
        Map<String, ScpServiceConfigRespVO> configRespVOMap = null;
        if(Boolean.TRUE.equals(orgStoreBaseRpcDTO.getDeliveryChargeFlag())
                || Boolean.TRUE.equals(orgStoreBaseRpcDTO.getWhChargeFlag())){
            //查询服务费
            configRespVOMap = scpServiceConfigService.findServiceConfigGroupByStore(orgStoreBaseRpcDTO.getStoreCode(),
                    orgStoreBaseRpcDTO.getRegion(), orgStoreBaseRpcDTO.getStoreLevel());
            if(configRespVOMap != null  && configRespVOMap.get("TECH") != null){
                entityRespVO.setFeeOuCode(configRespVOMap.get("TECH").getOuCode());
                entityRespVO.setFeeOuName(configRespVOMap.get("TECH").getOuName());
            }
        }
        List<OrgOuRpcSimpleDTO> allAppStoreSupplyOuRpcDto = orgOuRpcService.findAllAppStoreSupplyOuRpcDto();
        if(CollectionUtils.isNotEmpty(allAppStoreSupplyOuRpcDto)){
            entityRespVO.setSupplyOuList(allAppStoreSupplyOuRpcDto.stream().map(i -> {
                AppStoreServiceEntityRespVO.SupplyOuRespVO respVO = new AppStoreServiceEntityRespVO.SupplyOuRespVO();
                respVO.setSupplyOuCode(i.getOuCode());
                respVO.setSupplyOuName(i.getOuName());
                return respVO;
            }).collect(Collectors.toList()));
        }
        return entityRespVO;
    }
}
