package com.elitesland.scp.application.service.scpsman;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.authority.ScpsmanRegionPageQueryParam;
import com.elitesland.scp.application.facade.vo.scpsman.*;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.dto.scpsman.SalesmanLevelInfoDTO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/3/18 17:42
 * @Description:
 */
public interface ScpsmanInfoService {

    ApiResult<ScpsmanInfoDO> save(SalesmanInfoSaveVO salesmanInfoSaveVO);

    ApiResult<PagingVO<SalesmanInfoRespVO>> query(SalesmanInfoQueryVO salesmanInfoQueryVO);

    ApiResult<SalesmanInfoDetailRespVO> queryDetail(Long id);

    ApiResult<Object> changeStatus(SalesmanInfoChangeVO salesmanInfoChangeVO);

    ScpsmanImportRespVO salesmanImport(List<SalesmanImportSaveVO> recommendRelateCustVOS);

    SalesmanLevelInfoDTO queryLevelInfo(Long id);

    ApiResult<PagingVO<SalesmanDetailInfoRespVO>> querySalesmanAllInfo(SalesmanInfoQueryVO salesmanInfoQueryVO);

    ApiResult<PagingVO<SalesmanInfoRespVO>> querySubordinate(SalesmanSubordinateQueryVO salesmanSubordinateQueryVO);


    List<SalesmanInfoRespVO> queryByLoginAccount(String loginAccount);

    List<SalesmanInfoRespVO> queryByMobile(String mobile);






    /**
     * 新增管理区域
     *
     * @param save
     * @return
     */
    ApiResult<Boolean> addRegion(ScpsmanRegionSaveVO save);

    /**
     * 保存所有管理区域
     *
     * @param save
     * @return
     */
    ApiResult<Boolean> saveRegion(ScpsmanRegionSaveVO save);

    /**
     * 删除管理区域
     *
     * @param save
     * @return
     */
    ApiResult<Boolean> removeRegion(ScpsmanRegionSaveVO save);

    /**
     * 分页查询管理区域
     *
     * @param queryParam
     * @return
     */
    ApiResult<PagingVO<SalesmanRegionVO>> pageQuery(ScpsmanRegionPageQueryParam queryParam);

    /**
     * 迁移计划员权限
     *
     * @param id
     * @return
     */
    ApiResult<Boolean> migrateAuthority(Long id, Integer opType);
}
