package com.elitesland.scp.infr.repo.alloc;

import com.elitesland.scp.domain.entity.alloc.QScpAllocSettingBrandDO;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

@Component
@RequiredArgsConstructor
public class ScpAllocSettingBrandRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QScpAllocSettingBrandDO scpAllocSettingBrandDO = QScpAllocSettingBrandDO.scpAllocSettingBrandDO;

    public List<Long> findMasIdByBrand(String brand, Set<Long> masIds) {
        var jpaQuery = jpaQueryFactory.select(scpAllocSettingBrandDO.masId).distinct()
                .from(scpAllocSettingBrandDO);
        jpaQuery.where(scpAllocSettingBrandDO.brand.eq(brand));
        if(CollectionUtils.isNotEmpty(masIds)){
            jpaQuery.where(scpAllocSettingBrandDO.masId.in(masIds));
        }
        return jpaQuery.fetch();
    }

}
