package com.elitesland.scp.rmi;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.org.dto.OrgRegionDTO;
import com.elitesland.support.provider.org.param.OrgRegionQueryDTO;
import com.elitesland.support.provider.org.service.OrgRegionRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Component
@Slf4j
@RequiredArgsConstructor
public class RmiOrgRegionRpcService {

    private final OrgRegionRpcService orgRegionRpcService;

    /**
     * 查询区域信息集合
     *
     * @param regionCodes 区域编码
     * @return 区域信息
     */
    public Map<String, OrgRegionDTO> findRegionMapByCodes(List<String> regionCodes) {
        log.info("查询区域信息集合：regionCodes={}", regionCodes);
        try {
            ApiResult<List<OrgRegionDTO>> apiResult = orgRegionRpcService.findSimpleByRegionCodes(regionCodes);
            if (apiResult.isFailed()) {
                throw new BusinessException("查询区域信息接口异常:" + apiResult.getMsg());
            }
            if (CollectionUtils.isEmpty(apiResult.getData())) {
                return new HashMap<>();
            }
            log.info("查询区域列表结果:{}", JSONUtil.toJsonStr(apiResult.getData()));
            return apiResult.getData().stream().collect(Collectors.toMap(OrgRegionDTO::getRegionCode,  Function.identity(), (k1, k2) -> k1));
        } catch (Exception e) {
            log.error("查询区域信息集合失败:{}", e.getMessage());
            throw new BusinessException(ApiCode.FAIL, "查询区域信息集合接口异常:" + e);
        }
    }

    /**
     * 查询区域信息集合
     *
     * @param regionCodes 区域编码
     * @return 区域信息
     */
    public Map<String, OrgRegionDTO> findDetailRegionMapByCodes(List<String> regionCodes) {
        log.info("查询区域详细信息集合：regionCodes={}", regionCodes);
        try {
            OrgRegionQueryDTO param = new OrgRegionQueryDTO();
            param.setRegionCodes(new HashSet<>(regionCodes));
            param.setEnabled(true);
            ApiResult<List<OrgRegionDTO>> apiResult = orgRegionRpcService.queryList(param);
            if (apiResult.isFailed()) {
                throw new BusinessException("查询区域详细信息接口异常:" + apiResult.getMsg());
            }
            if (CollectionUtils.isEmpty(apiResult.getData())) {
                return new HashMap<>();
            }
            log.info("查询区域详细信息列表结果:{}", JSONUtil.toJsonStr(apiResult.getData()));
            return apiResult.getData().stream().collect(Collectors.toMap(OrgRegionDTO::getRegionCode, Function.identity(), (k1, k2) -> k1));
        } catch (Exception e) {
            log.error("查询区域详细信息集合失败:{}", e.getMessage());
            throw new BusinessException(ApiCode.FAIL, "查询区域详细信息集合接口异常:" + e);
        }
    }
}
