package com.elitesland.scp.application.service.setting;

import cn.hutool.json.JSONUtil;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingParamVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.domain.convert.setting.ScpOrderSettingConvert;
import com.elitesland.scp.param.ScpOrderSettingRpcParamVO;
import com.elitesland.scp.param.ScpOrderSettingRpcRespVO;
import com.elitesland.scp.service.orderSetting.ScpOrderSettingRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/8/24 17:51
 * @Description:
 */
@Slf4j
@Service
@RequiredArgsConstructor
@RestController
@RequestMapping(ScpApplication.URI_PREFIX + ScpOrderSettingRpcService.PATH)
public class ScpOrderSettingRpcServiceImpl implements ScpOrderSettingRpcService {

    private final ScpOrderSettingService scpOrderSettingService;

    @Override
    public List<ScpOrderSettingRpcRespVO> queryOrderSettingList(ScpOrderSettingRpcParamVO paramVO) {
        log.info("单据类型配置查询,参数:{}", JSONUtil.toJsonStr(paramVO));
        ScpOrderSettingParamVO param =
                ScpOrderSettingConvert.INSTANCE.apiParmToServiceParam(paramVO);
        List<ScpOrderSettingRespVO> data = scpOrderSettingService.queryOrderSettingList(param);
        log.info("单据类型配置查询,结果:{}", JSONUtil.toJsonStr(data));
        return ScpOrderSettingConvert.INSTANCE.ServiceRespToApiRespList(data);
    }
}
