package com.elitesland.scp.infr.repo.alloc;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingPageRespVO;
import com.elitesland.scp.domain.entity.alloc.QScpAllocSettingDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
public class ScpAllocSettingRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QScpAllocSettingDO scpAllocSettingDO = QScpAllocSettingDO.scpAllocSettingDO;

    public long countAllocSetting(ScpAllocSettingPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpAllocSettingDO.count())
                .from(scpAllocSettingDO);
        jpaQuery.where(this.whereAllocSettingPage(paramVO));
        return jpaQuery.fetchCount();
    }

    private final QBean<ScpAllocSettingPageRespVO> pageList = Projections.bean(
            ScpAllocSettingPageRespVO.class,
            scpAllocSettingDO.id,
            scpAllocSettingDO.docType,
            scpAllocSettingDO.activityCode,
            scpAllocSettingDO.activityName,
            scpAllocSettingDO.activityType,
            scpAllocSettingDO.validFrom,
            scpAllocSettingDO.validTo,
            scpAllocSettingDO.status,
            scpAllocSettingDO.creator,
            scpAllocSettingDO.createUserId,
            scpAllocSettingDO.createTime,
            scpAllocSettingDO.updater,
            scpAllocSettingDO.modifyUserId,
            scpAllocSettingDO.modifyTime,
            scpAllocSettingDO.remark
    );

    public List<ScpAllocSettingPageRespVO> queryAllocSetting(ScpAllocSettingPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(pageList)
                .from(scpAllocSettingDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpAllocSettingDO);
        jpaQuery.where(this.whereAllocSettingPage(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate whereAllocSettingPage(ScpAllocSettingPageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (StrUtil.isNotBlank(paramVO.getDocType())) {
            predicates.add(scpAllocSettingDO.docType.eq(paramVO.getDocType()));
        }
        if (paramVO.getValidFrom() != null && paramVO.getValidTo() != null) {
            predicates.add(scpAllocSettingDO.validFrom.loe(paramVO.getValidFrom()).and(scpAllocSettingDO.validTo.goe(paramVO.getValidTo())));
        }
        if (paramVO.getStatus() != null) {
            predicates.add(scpAllocSettingDO.status.eq(paramVO.getStatus()));
        }
        if (StrUtil.isNotBlank(paramVO.getActivityCodeName())) {
            predicates.add(scpAllocSettingDO.activityCode.like("%" + paramVO.getActivityCodeName() + "%").or(scpAllocSettingDO.activityName.like("%" + paramVO.getActivityCodeName() + "%")));
        }
        if (CollUtil.isNotEmpty(paramVO.getIds())) {
            predicates.add(scpAllocSettingDO.id.in(paramVO.getIds()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public void enableAllocSetting(List<Long> ids, Boolean enable) {
        JPAUpdateClause update = jpaQueryFactory.update(scpAllocSettingDO)
                .set(scpAllocSettingDO.status, enable)
                .where(scpAllocSettingDO.id.in(ids));
        update.execute();
    }

    public long deleteByIds(List<Long> ids) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(scpAllocSettingDO.id.in(ids));
        var delete = jpaQueryFactory.delete(scpAllocSettingDO)
                .where(ExpressionUtils.allOf(predicates));
        return delete.execute();
    }

}
