package com.elitesland.scp.infr.repo.msg;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.scp.domain.entity.msg.QScpMessageTxtDO;
import com.elitesland.scp.domain.entity.msg.ScpMessageTxtDO;
import org.springframework.stereotype.Repository;

import java.util.Collection;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/28
 */
@Repository
public class ScpMessageTxtRepoProc extends BaseRepoProc<ScpMessageTxtDO> {
    private static final QScpMessageTxtDO QDO = QScpMessageTxtDO.scpMessageTxtDO;

    public ScpMessageTxtRepoProc() {
        super(QDO);
    }

    public void deleteByMessageId(long messageId) {
        super.deleteByValue(QDO.messageId, messageId);
    }

    public void deleteByMessageId(Collection<Long> messageIds) {
        super.deleteByValue(QDO.messageId, messageIds);
    }

    public String getTxt(long id) {
        return super.getValue(QDO.txt, id);
    }

    public String getTxtByMessageId(long messageId) {
        return super.getValueByValue(QDO.txt, QDO.messageId, messageId);
    }

}
