package com.elitesland.scp.infr.repo.storereceive;

import com.elitesland.scp.domain.entity.storereceive.StoreReceiveDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;
import java.util.List;

@Repository
public interface StoreReceiveRepo extends JpaRepository<StoreReceiveDO, Long>, QuerydslPredicateExecutor<StoreReceiveDO> {

    List<StoreReceiveDO> findAllByDocId(Long docId);

    StoreReceiveDO findByDocId(Long docId);

    List<StoreReceiveDO> findAllByOrderId(Long orderId);

    List<StoreReceiveDO> findAllByIdIn(Collection<Long> ids);

    List<StoreReceiveDO> findAllByStoreIdIn(List<Long> storeIds);

    List<StoreReceiveDO> findAllByOrderIdAndRtTypeAndStatusNotIn(Long orderId, String rtType, List<String> statusList);

    void deleteAllById(Long id);

    @Modifying()
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_store_receive set status = ?2 where id = ?1", nativeQuery = true)
    void updateStatusById(Long id, String status);
}
