package com.elitesland.scp.application.facade.vo.param.order;


import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.time.LocalDateTime;

@Data
@ApiModel(value = "订货集查询参数")
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class ScpDemandSetPageParamVO extends AbstractOrderQueryParam {

    @ApiModelProperty("类型")
    private String type;

    @ApiModelProperty("订货集编码")
    private String demandCode;

    @ApiModelProperty("订货集名称")
    private String demandName;

    @ApiModelProperty("需求日期开始")
    private LocalDateTime demandDateFrom;

    @ApiModelProperty("需求日期结束")
    private LocalDateTime demandDateTo;

    @ApiModelProperty("状态")
    private Boolean status;

    @ApiModelProperty("是否已推送")
    private Boolean isPushed;
}
