package com.elitesland.scp.application.service.authority;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.dto.CustBaseInfoDTO;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.resp.authority.ScmsmanLoginStoreRespVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityBusinessTypeVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpsmanAuthorityComponentVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.domain.service.survey.SurveyService;
import com.elitesland.scp.domain.vo.survey.SurveyCheckRespVO;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepoProc;
import com.elitesland.scp.rmi.RmiSalRpcService;
import com.elitesland.support.provider.item.service.ItemRecvAddressRpcService;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/12 周五
 */
@Service
public class ScpsmanAuthorityComponentImpl implements ScpsmanAuthorityComponentService {
    private static final Logger logger = LoggerFactory.getLogger(ScpsmanAuthorityComponentImpl.class);

    @Autowired
    private ScpsmanInfoRepoProc scpsmanInfoRepoProc;
    @Autowired
    private OrgStoreRpcService orgStoreRpcService;
    @Autowired
    private UdcProvider udcProvider;
    @Autowired
    private ScpOrderSettingDomainService scpOrderSettingDomainService;
    @Autowired
    private ItemRecvAddressRpcService itemRecvAddressRpcService;
    @Autowired
    private RmiSalRpcService rmiSalRpcService;
    @Autowired
    private ScpsmanAuthorityManager scpsmanAuthorityManager;
    @Autowired
    private SurveyService surveyService;

    @SysCodeProc
    @Override
    public PagingVO<ScpsmanAuthorityComponentVO> salemansAuthorityComponentPage(ScpManAuthorityParam paramVO) {
        var voList = storeList(paramVO);

        return new PagingVO<>(voList.size(), voList);
    }

    @Override
    public List<ScpsmanAuthorityComponentVO> storeList(ScpManAuthorityParam paramVO) {
        var user = SecurityContextUtil.currentUserIfUnauthorizedThrow();

        // 计划员信息
        var scpsmanInfo = scpsmanInfoRepoProc.getByScpsmanNo(user.getUsername());
        if (scpsmanInfo == null) {
            return Collections.emptyList();
        }

        // 查询权限门店信息
        Map<String, OrgStoreBaseRpcDTO> storeMap = scpsmanAuthorityManager.queryStoreList(user, scpsmanInfo,
                ObjectUtil.defaultIfNull(paramVO.getSize(), -1), paramVO.getKeyword());
        if (storeMap.isEmpty()) {
            return Collections.emptyList();
        }

        // 业务类型配置
        var scpsmanBusinessTypeVOS = queryScpManBusinessType(scpsmanInfo, paramVO.getType() == null ? null : paramVO.getType().toString());

        var storeType2Map = udcProvider.getValueMapByUdcCode("yst-supp", "STORE_TYPE2");

        List<String> ouCodeList = storeMap.values().stream().map(OrgStoreBaseRpcDTO::getStoreCode).distinct().toList();
        Map<String, List<SurveyCheckRespVO>> collect = surveyService.findSurvey(user.getUsername(), ouCodeList).stream().collect(Collectors.groupingBy(SurveyCheckRespVO::getStoreCode));
        return storeMap.values().stream().map(t -> {
            ScpsmanAuthorityComponentVO componentVO = new ScpsmanAuthorityComponentVO();
            componentVO.setScpsmanId(scpsmanInfo.getId());
            componentVO.setScpsmanNo(scpsmanInfo.getScpsmanNo());
            componentVO.setScpsman(scpsmanInfo.getName());
            componentVO.setOuId(scpsmanInfo.getOuId());
            componentVO.setOuName(scpsmanInfo.getOuName());
            componentVO.setOuCode(scpsmanInfo.getOuCode());
            componentVO.setEnableStatus(true);
            componentVO.setEnableStatusName("激活");

            componentVO.setType(0);
            componentVO.setTypeName("门店");

            componentVO.setStWhId(t.getId());
            componentVO.setStWhCode(t.getStoreCode());
            componentVO.setStWhName(t.getStoreName());
            componentVO.setStoreType2(t.getStoreType2());
            componentVO.setStoreType2Name(storeType2Map.get(t.getStoreType2()));
            componentVO.setStCustCode(t.getCustCode());
            componentVO.setStCustName(t.getCustName());
            componentVO.setBrandCode(t.getBrandCode());
            componentVO.setStoreOuCode(t.getOuCode());
            componentVO.setDailyFlag(t.getDailyFlag());
            componentVO.setPreDailyFlag(t.getPreDailyFlag());

            if (UdcEnum.SALE_SCPSMAN_TYPE_SHOPOWNER.getValueCode().equals(scpsmanInfo.getScpsmanType())) {
                //校验是否已设置密码
                componentVO.setPasswordSetFlag(!orgStoreRpcService.existStorePayPassword(t.getStoreCode()).computeData());
            } else {
                componentVO.setPasswordSetFlag(Boolean.FALSE);
            }

            componentVO.setScpsmanType(scpsmanInfo.getScpsmanType());
            componentVO.setBusinessTypeAuths(scpsmanBusinessTypeVOS);
            componentVO.setHasAddress(itemRecvAddressRpcService.hasAddress(t.getStoreCode()));
            componentVO.setProtocolAgreeStatus(t.getProtocolAgreeStatus());
            componentVO.setProtocolAgreeUserPhone(t.getProtocolAgreeUserPhone());
            componentVO.setProtocolAgreeUserName(t.getProtocolAgreeUserName());
            componentVO.setLegalName(t.getLegalName());
            componentVO.setLegalPhone(t.getLegalPhone());

            // 问卷
            if(collect.containsKey(t.getStoreCode())){
                componentVO.setSurvey(collect.get(t.getStoreCode()).get(0));
            }

            return componentVO;
        }).collect(Collectors.toList());
    }

    @Override
    public List<ScpManAuthorityBusinessTypeVO> businessTypeQuery(ScpManAuthorityParam paramVO) {
        var user = SecurityContextUtil.currentUserIfUnauthorizedThrow();

        // 计划员信息
        var scpManInfo = scpsmanInfoRepoProc.getByScpsmanNo(user.getUsername());
        if (scpManInfo == null) {
            return Collections.emptyList();
        }

        // 业务类型配置
        return queryScpManBusinessType(scpManInfo, paramVO.getType() == null ? null : paramVO.getType().toString());
    }

    @Override
    public ScpsmanAuthorityComponentVO appQuery(ScpManAuthorityParam paramVO) {
        var user = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        //默认查询门店
        paramVO.setType(0L);
        paramVO.setSize(1);
        // 查询门店
        var voList = storeList(paramVO);

        ScpsmanAuthorityComponentVO componentVO = null;
        if (voList.isEmpty()) {
            // 计划员信息
            var scpsmanInfo = scpsmanInfoRepoProc.getByScpsmanNo(user.getUsername());
            if (scpsmanInfo == null) {
                return new ScpsmanAuthorityComponentVO();
            }
            componentVO = new ScpsmanAuthorityComponentVO();
            componentVO.setScpsmanId(scpsmanInfo.getId());
            componentVO.setScpsmanNo(scpsmanInfo.getScpsmanNo());
            componentVO.setScpsman(scpsmanInfo.getName());
            componentVO.setOuId(scpsmanInfo.getOuId());
            componentVO.setOuName(scpsmanInfo.getOuName());
            componentVO.setOuCode(scpsmanInfo.getOuCode());
            componentVO.setEnableStatus(true);
            componentVO.setEnableStatusName("激活");

            componentVO.setType(0);
            componentVO.setTypeName("门店");

            componentVO.setPasswordSetFlag(Boolean.FALSE);

            componentVO.setScpsmanType(scpsmanInfo.getScpsmanType());
            componentVO.setBusinessTypeAuths(Collections.emptyList());
            componentVO.setHasAddress(false);
        } else {
            componentVO = voList.get(0);
            logger.info("【appQuery】获取当前登录账号对应的计划员权限所属门店结果：{}", JSONUtil.toJsonStr(componentVO));
            if (UdcEnum.SALE_SCPSMAN_TYPE_SHOPOWNER.getValueCode().equals(componentVO.getScpsmanType())) {
                //校验是否已设置密码
                if (orgStoreRpcService.existStorePayPassword(componentVO.getStWhCode()).computeData()) {
                    componentVO.setPasswordSetFlag(Boolean.FALSE);
                } else {
                    componentVO.setPasswordSetFlag(Boolean.TRUE);
                }
            } else {
                componentVO.setPasswordSetFlag(Boolean.FALSE);
            }
            this.storeTypeQuery(componentVO);
        }

        return componentVO;
    }

    @Override
    public List<String> loginAndTypeQuery(ScpManAuthorityParam paramVO) {
        var user = SecurityContextUtil.currentUserIfUnauthorizedThrow();

        // 计划员信息
        var scpsmanInfo = scpsmanInfoRepoProc.getByScpsmanNo(user.getUsername());
        if (scpsmanInfo == null) {
            return Collections.emptyList();
        }

        // 查询权限门店信息
        Map<String, OrgStoreBaseRpcDTO> storeMap = scpsmanAuthorityManager.queryStoreList(user, scpsmanInfo, -1);
        return new ArrayList<>(storeMap.keySet());
    }

    @Override
    public ApiResult<ScmsmanLoginStoreRespVO> getLoginStoreByCurrentUser() {
        var currentUser = UserService.currentUser();
        if (ObjectUtil.isEmpty(currentUser)) {
            throw new BusinessException("当前登录人查询异常");
        }

        ScmsmanLoginStoreRespVO respVO = new ScmsmanLoginStoreRespVO();
        respVO.setOnlyOne(false);

        // 先尝试根据登录号和员工编号查询
        GeneralUserDetails userDetails = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        List<String> userNames = getCandidateStoreCodeByUser(userDetails);
        if (userNames.isEmpty()) {
            return ApiResult.ok(respVO);
        }

        // 查询门店
        logger.info("查询门店：{}", com.elitescloud.boot.util.JSONUtil.toJsonString(userNames));
        OrgStoreBaseRpcParam storeParam = new OrgStoreBaseRpcParam();
        storeParam.setStoreCodeList(userNames);
        var storeList = orgStoreRpcService.findSimpleStoreByParam(storeParam).computeData();
        if (CollUtil.isEmpty(storeList)) {
            return ApiResult.ok(respVO);
        }

        respVO.setStoreCodeDef(storeList.get(0).getStoreCode());
        respVO.setOnlyOne(true);

        return ApiResult.ok(respVO);
    }

    private void storeTypeQuery(ScpsmanAuthorityComponentVO scpsmanAuthorityComponentVO) {
        if (Objects.isNull(scpsmanAuthorityComponentVO)) {
            return;
        }
//        OrgStoreDetailRpcDTO byCode = rmiOrgStoreRpcService.getByCode(scpsmanAuthorityComponentVO.getStWhCode());
//        if (Objects.nonNull(byCode)) {
//            scpsmanAuthorityComponentVO.setStoreType2(byCode.getStoreType2());
//            scpsmanAuthorityComponentVO.setStoreType2Name(byCode.getStoreType2Name());
//            scpsmanAuthorityComponentVO.setStoreOuCode(byCode.getOuCode());
//            if (StringUtils.isBlank(scpsmanAuthorityComponentVO.getStCustCode())) {
//                //门店客户(子客户)
//                scpsmanAuthorityComponentVO.setStCustCode(byCode.getCustCode());
//                scpsmanAuthorityComponentVO.setStCustName(byCode.getCustName());
//
//            }
//        }
        //查看门店客户的主客户和是否是外部
        if (StringUtils.isNotBlank(scpsmanAuthorityComponentVO.getStCustCode())) {
            List<CustBaseDTO> custBaseInfoDTOList = rmiSalRpcService.findBaseByParam(Collections.singletonList(scpsmanAuthorityComponentVO.getStCustCode()));
            if (CollectionUtil.isNotEmpty(custBaseInfoDTOList)) {
                CustBaseDTO custBaseInfoDTO = custBaseInfoDTOList.get(0);
                //主客户
                scpsmanAuthorityComponentVO.setStoreCustCode(custBaseInfoDTO.getPreCustCode());

                //主客户的信息
                if (StringUtils.isNotBlank(scpsmanAuthorityComponentVO.getStoreCustCode())) {
                    List<CustBaseInfoDTO> custBaseInfoDTOS = rmiSalRpcService.getCustBaseInfoByCode(Collections.singletonList(scpsmanAuthorityComponentVO.getStoreCustCode()));
                    if (CollectionUtil.isNotEmpty(custBaseInfoDTOS)) {
                        CustBaseInfoDTO custBaseInfoDTO1 = custBaseInfoDTOS.get(0);
                        scpsmanAuthorityComponentVO.setStoreCustName(custBaseInfoDTO1.getCustName());
                        if (Objects.equals(custBaseInfoDTO1.getCustType2(), "A")) {
                            scpsmanAuthorityComponentVO.setStoreCustType2Flag(true);
                        }
                    }
                }
            }
        }
    }

    private List<ScpManAuthorityBusinessTypeVO> queryScpManBusinessType(ScpsmanInfoDO scpsmanInfoDO, String type) {
        String businessTypes = scpsmanInfoDO.getBusinessType();
        if (StrUtil.isBlank(businessTypes)) {
            return Collections.emptyList();
        }

        List<ScpManAuthorityBusinessTypeVO> scpManAuthorityBusinessTypeVOS = new ArrayList<>();
        Map<String, String> businessTypeUDCMap = udcProvider.getValueMapByUdcCode("yst-suplan", "BUSINESS_TYPE");

        List<String> businessTypeList = Arrays.stream(businessTypes.split(",")).toList();
        for (String businessType : businessTypeList) {
            ScpOrderSettingRespVO cacheByBusinessType = scpOrderSettingDomainService.findCacheByBusinessType(businessType, type);
            ScpManAuthorityBusinessTypeVO scpManAuthorityBusinessTypeVO = new ScpManAuthorityBusinessTypeVO();
            scpManAuthorityBusinessTypeVO.setBusinessType(businessType);
            scpManAuthorityBusinessTypeVO.setBusinessTypeName(businessTypeUDCMap.get(businessType));
            scpManAuthorityBusinessTypeVO.setAllowDiscount(cacheByBusinessType.getAllowDiscount());
            scpManAuthorityBusinessTypeVOS.add(scpManAuthorityBusinessTypeVO);
        }

        return scpManAuthorityBusinessTypeVOS;
    }

    private List<String> getCandidateStoreCodeByUser(GeneralUserDetails userDetails) {
        List<String> userNames = new ArrayList<>(4);

        String loginAccount = userDetails.getLoginAccount();
        if (StrUtil.isNotBlank(loginAccount)) {
            if (loginAccount.equals(userDetails.getUser().getMobile())) {
                // 手机号则直接返回
                return Collections.emptyList();
            }

            userNames.add(loginAccount);
        }
        if (StrUtil.isNotBlank(userDetails.getUser().getEmployeeCode())) {
            userNames.add(userDetails.getUser().getEmployeeCode());
        }
        return userNames;
    }
}
