/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.scpsman;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeePageQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeePageRespDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitescloud.cloudt.system.provider.org.OrgRpcService;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanComponentPageRespVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanParamVO;
import com.elitesland.scp.application.service.scpsman.ScpsmanComponentService;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanComponentRepoProc;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepoProc;
import com.elitesland.scp.rmi.RmiOrgOuService;
import com.elitesland.support.provider.org.dto.OrgOuRpcDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScpsmanComponentServiceImpl
implements ScpsmanComponentService {
    private static final Logger log = LoggerFactory.getLogger(ScpsmanComponentServiceImpl.class);
    private final RmiOrgOuService rmiOrgOuService;
    private final ScpsmanComponentRepoProc scpsmanComponentRepoProc;
    @Autowired
    private EmployeeRpcService employeeRpcService;
    @Autowired
    private UdcProvider udcProvider;
    @Autowired
    private OrgRpcService orgRpcService;
    @Autowired
    private ScpsmanInfoRepoProc scpsmanInfoRepoProc;

    @Override
    public PagingVO<SalesmanComponentPageRespVO> salemansComponentPage(SalesmanParamVO paramVO) {
        ArrayList<String> agentEmpCodes = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)paramVO.getPhone()) || ObjectUtils.isNotEmpty((Object)paramVO.getOrgId()) || ObjectUtils.isNotEmpty((Object)paramVO.getOrgCode())) {
            List<String> empCodesParam;
            if (StringUtils.isNotBlank((CharSequence)paramVO.getOrgCode())) {
                SysOrgBasicDTO sysOrgBasic = this.getOrgByCode(paramVO.getOrgCode());
                if (ObjectUtils.isEmpty((Object)sysOrgBasic)) {
                    return new PagingVO();
                }
                paramVO.setOrgId(sysOrgBasic.getId());
            }
            if (ObjectUtils.isEmpty(empCodesParam = this.getEmpCodes(paramVO))) {
                return new PagingVO();
            }
            agentEmpCodes.addAll(empCodesParam);
        }
        paramVO.setCodes(agentEmpCodes);
        PagingVO<SalesmanComponentPageRespVO> salemansPage = this.scpsmanComponentRepoProc.salemanComponemtPage(paramVO);
        if (salemansPage.isEmpty()) {
            return new PagingVO();
        }
        List<String> empCodes = salemansPage.getRecords().stream().map(SalesmanComponentPageRespVO::getScpsmanNo).collect(Collectors.toList());
        Map<String, SysEmployeeDetailDTO> empMap = this.getEmpMap(empCodes);
        Map salesmanTypeUDCMap = this.udcProvider.getValueMapByUdcCode("yst-suplan", "SCPSMAN_TYPE");
        salemansPage.getRecords().forEach(s -> {
            List<OrgOuRpcDTO> ous;
            if (MapUtils.isNotEmpty((Map)empMap) && ObjectUtils.isNotEmpty(empMap.get(s.getScpsmanNo()))) {
                s.setName(((SysEmployeeDetailDTO)empMap.get(s.getScpsmanNo())).getFullName());
                s.setPhone(((SysEmployeeDetailDTO)empMap.get(s.getScpsmanNo())).getPhone());
                s.setUserId(((SysEmployeeDetailDTO)empMap.get(s.getScpsmanNo())).getUserId());
                SysEmployeeDetailDTO emp = (SysEmployeeDetailDTO)empMap.get(s.getScpsmanNo());
                if (ObjectUtils.isNotEmpty((Object)emp) && CollectionUtil.isNotEmpty((Collection)emp.getOrgList())) {
                    List<ScpsmanInfoDO> mans;
                    SysOrgBasicDTO sysOrgBasic;
                    SysEmployeeDetailDTO.EmployeeOrg leaderEmp = (SysEmployeeDetailDTO.EmployeeOrg)emp.getOrgList().get(0);
                    s.setOrgName(leaderEmp.getOrgName());
                    s.setOrgId(leaderEmp.getOrgId());
                    if (ObjectUtils.isNotEmpty((Object)leaderEmp.getOrgId()) && ObjectUtils.isNotEmpty((Object)(sysOrgBasic = this.getOrgById(leaderEmp.getOrgId())))) {
                        s.setOrgCode(sysOrgBasic.getCode());
                    }
                    s.setLeaderUserFullName(leaderEmp.getLeaderUserFullName());
                    s.setLeaderEmployeeCode(leaderEmp.getLeaderEmployeeCode());
                    s.setLeaderUserId(leaderEmp.getLeaderUserId());
                    s.setLeaderEmployeeId(leaderEmp.getLeaderEmployeeId());
                    if (StringUtils.isNotBlank((CharSequence)leaderEmp.getLeaderEmployeeCode()) && CollectionUtil.isNotEmpty(mans = this.scpsmanInfoRepoProc.getSalesmanByCodes(Collections.singleton(leaderEmp.getLeaderEmployeeCode())))) {
                        s.setLeaderSalemansId(mans.get(0).getId());
                    }
                }
            }
            if (!ObjectUtils.isEmpty((Object)s.getOuId()) && CollectionUtil.isNotEmpty(ous = this.rmiOrgOuService.findOuDtoList(Collections.singletonList(s.getOuId()), null))) {
                s.setCurrCode(ous.get(0).getOuCurr());
            }
            if (StringUtils.isNotBlank((CharSequence)s.getScpsmanType()) && ObjectUtils.isNotEmpty((Object)salesmanTypeUDCMap) && ObjectUtils.isNotEmpty(salesmanTypeUDCMap.get(s.getScpsmanType()))) {
                s.setScpsmanTypeName((String)salesmanTypeUDCMap.get(s.getScpsmanType()));
            }
            s.setEnableStatusName(s.getEnableStatus() == 1 ? "\u542f\u7528" : "\u7981\u7528");
        });
        return salemansPage;
    }

    public Map<String, SysEmployeeDetailDTO> getEmpMap(List<String> empCodes) {
        HashSet<String> codeSet = new HashSet<String>(empCodes);
        ApiResult serviceDetailList = this.employeeRpcService.getDetailListByCode(codeSet);
        if (serviceDetailList.isFailed()) {
            throw new BusinessException("\u67e5\u8be2\u5458\u5de5\u4fe1\u606f\u5931\u8d25");
        }
        if (CollectionUtil.isEmpty((Collection)((Collection)serviceDetailList.getData()))) {
            return new HashMap<String, SysEmployeeDetailDTO>();
        }
        List emps = (List)serviceDetailList.getData();
        return emps.stream().collect(Collectors.toMap(SysEmployeeDetailDTO::getCode, Function.identity(), (t1, t2) -> t1));
    }

    public SysOrgBasicDTO getOrgByCode(String code) {
        ApiResult apiResult = this.orgRpcService.getByCode(code);
        if (apiResult.isSuccess() && !ObjectUtils.isEmpty((Object)apiResult.getData())) {
            return (SysOrgBasicDTO)apiResult.getData();
        }
        return null;
    }

    public SysOrgBasicDTO getOrgById(Long id) {
        ApiResult apiResult = this.orgRpcService.getById(id);
        if (apiResult.isSuccess() && !ObjectUtils.isEmpty((Object)apiResult.getData())) {
            return (SysOrgBasicDTO)apiResult.getData();
        }
        return null;
    }

    public List<String> getEmpCodes(SalesmanParamVO paramVO) {
        EmployeePageQueryDTO employeePageQueryDTO = new EmployeePageQueryDTO();
        employeePageQueryDTO.setPhone(paramVO.getPhone());
        if (ObjectUtils.isNotEmpty((Object)paramVO.getOrgId())) {
            employeePageQueryDTO.setOrgId(paramVO.getOrgId());
        }
        employeePageQueryDTO.setSize(Integer.valueOf(1000));
        ApiResult result = this.employeeRpcService.queryByPage(employeePageQueryDTO);
        if (result.isFailed()) {
            throw new BusinessException("\u67e5\u8be2\u5458\u5de5\u4fe1\u606f\u5931\u8d25");
        }
        if (((PagingVO)result.getData()).isEmpty()) {
            return new ArrayList<String>();
        }
        List emps = ((PagingVO)result.getData()).getRecords();
        return emps.stream().map(EmployeePageRespDTO::getCode).collect(Collectors.toList());
    }

    public ScpsmanComponentServiceImpl(RmiOrgOuService rmiOrgOuService, ScpsmanComponentRepoProc scpsmanComponentRepoProc) {
        this.rmiOrgOuService = rmiOrgOuService;
        this.scpsmanComponentRepoProc = scpsmanComponentRepoProc;
    }
}

