/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.alloc;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingSaveVO;
import com.elitesland.scp.domain.convert.alloc.ScpAllocSettingConvert;
import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingDO;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingDomainService;
import com.elitesland.scp.infr.dto.alloc.ScpAllocSettingDTO;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingRepo;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingRepoProc;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingStoreRepoProc;
import com.elitesland.scp.rmi.RmiSysUDCService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScpAllocSettingDomainServiceImpl
implements ScpAllocSettingDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpAllocSettingDomainServiceImpl.class);
    private final ScpAllocSettingRepo scpAllocSettingRepo;
    private final ScpAllocSettingRepoProc scpAllocSettingRepoProc;
    private final ScpAllocSettingStoreRepoProc scpAllocSettingStoreRepoProc;
    private final RmiSysUDCService rmiSysUDCService;

    @Override
    @SysCodeProc
    public PagingVO<ScpAllocSettingPageRespVO> queryAllocSettingList(ScpAllocSettingPageParamVO paramVO) {
        long count = this.scpAllocSettingRepoProc.countAllocSetting(paramVO);
        if (count > 0L) {
            Map<String, String> docTypeMap = this.rmiSysUDCService.getCodeMap("yst-suplan", "OB_DOC_TYPE");
            List<ScpAllocSettingPageRespVO> allocSettings = this.scpAllocSettingRepoProc.queryAllocSetting(paramVO);
            Map<Long, Long> usedIdMap = this.getUsedIdMap(allocSettings);
            allocSettings.forEach(item -> {
                if (StrUtil.isNotBlank((CharSequence)item.getDocType())) {
                    List<String> itemCateName = StrUtil.split((CharSequence)item.getDocType(), (char)',').stream().map(docTypeMap::get).collect(Collectors.toList());
                    item.setDocTypeNames(itemCateName);
                }
                item.setUseFlag(usedIdMap.containsKey(item.getId()));
            });
            return new PagingVO(count, allocSettings);
        }
        return new PagingVO();
    }

    private Map<Long, Long> getUsedIdMap(List<ScpAllocSettingPageRespVO> allocSettings) {
        List<Long> ids = allocSettings.stream().map(BaseViewModel::getId).collect(Collectors.toList());
        List<Long> usedSettings = this.scpAllocSettingStoreRepoProc.findUsedSettingByMasIds(ids);
        if (CollUtil.isNotEmpty(usedSettings)) {
            return usedSettings.stream().collect(Collectors.toMap(Long::valueOf, Function.identity()));
        }
        return new HashMap<Long, Long>();
    }

    @Override
    @SysCodeProc
    public Optional<ScpAllocSettingDTO> findAllocSettingById(Long id) {
        return this.scpAllocSettingRepo.findById(id).map(row -> {
            ScpAllocSettingDTO scpAllocSettingDTO = ScpAllocSettingConvert.INSTANCE.doToDto((ScpAllocSettingDO)row);
            return scpAllocSettingDTO;
        });
    }

    @Override
    public Long saveAllocSetting(ScpAllocSettingSaveVO saveVO) {
        if (saveVO.getId() == null) {
            ScpAllocSettingDO intentDO = ScpAllocSettingConvert.INSTANCE.saveVoToDO(saveVO);
            intentDO.setDocType(StrUtil.join((CharSequence)",", saveVO.getDocTypes()));
            Long masId = ((ScpAllocSettingDO)this.scpAllocSettingRepo.save(intentDO)).getId();
            return masId;
        }
        Optional<ScpAllocSettingDO> option = this.scpAllocSettingRepo.findById(saveVO.getId());
        if (option.isEmpty()) {
            throw new BusinessException("\u8ba2\u8d27\u5f3a\u914d\u6d3b\u52a8ID\uff1a" + saveVO.getId() + "\u4e0d\u5b58\u5728");
        }
        ScpAllocSettingDO scpAllocSettingDO = option.get();
        ScpAllocSettingConvert.INSTANCE.copySaveParamToDo(saveVO, scpAllocSettingDO);
        scpAllocSettingDO.setDocType(StrUtil.join((CharSequence)",", saveVO.getDocTypes()));
        Long masId = ((ScpAllocSettingDO)this.scpAllocSettingRepo.save(scpAllocSettingDO)).getId();
        return masId;
    }

    @Override
    public void enableAllocSetting(List<Long> ids, Boolean enable) {
        this.scpAllocSettingRepoProc.enableAllocSetting(ids, enable);
    }

    @Override
    public void deleteByIds(List<Long> ids) {
        List<ScpAllocSettingDO> settingDOS = this.scpAllocSettingRepo.findByIdIn(ids);
        this.scpAllocSettingRepoProc.deleteByIds(ids);
    }

    public ScpAllocSettingDomainServiceImpl(ScpAllocSettingRepo scpAllocSettingRepo, ScpAllocSettingRepoProc scpAllocSettingRepoProc, ScpAllocSettingStoreRepoProc scpAllocSettingStoreRepoProc, RmiSysUDCService rmiSysUDCService) {
        this.scpAllocSettingRepo = scpAllocSettingRepo;
        this.scpAllocSettingRepoProc = scpAllocSettingRepoProc;
        this.scpAllocSettingStoreRepoProc = scpAllocSettingStoreRepoProc;
        this.rmiSysUDCService = rmiSysUDCService;
    }
}

