/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.authority;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitesland.support.provider.org.service.OrgRegionRpcService;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ScpDemandAuthorityManager {
    @Autowired
    private OrgRegionRpcService orgRegionRpcService;
    @Autowired
    private UdcProvider udcProvider;

    public <T> void convertRegionName(List<T> dataList, Predicate<T> useUdc, Function<T, String> getRegionCode, BiConsumer<T, String> setRegionName) {
        if (CollUtil.isEmpty(dataList)) {
            return;
        }
        HashSet<String> regionCodes = new HashSet<String>(dataList.size());
        HashSet<String> udcRegionCodes = new HashSet<String>(dataList.size());
        for (T t : dataList) {
            String regionCode = getRegionCode.apply(t);
            if (CharSequenceUtil.isBlank((CharSequence)regionCode)) continue;
            if (useUdc.test(t)) {
                udcRegionCodes.add(regionCode);
                continue;
            }
            regionCodes.add(regionCode);
        }
        if (regionCodes.isEmpty() && udcRegionCodes.isEmpty()) {
            return;
        }
        Map regionNameMap = regionCodes.isEmpty() ? Collections.emptyMap() : (Map)this.orgRegionRpcService.getNameByCode(regionCodes).computeData();
        Map udcRegionMap = udcRegionCodes.isEmpty() ? Collections.emptyMap() : this.udcProvider.getValueMapByUdcCode("yst-supp", "REGION");
        for (T t : dataList) {
            String regionCode = getRegionCode.apply(t);
            if (CharSequenceUtil.isBlank((CharSequence)regionCode)) continue;
            String regionName = useUdc.test(t) ? (String)udcRegionMap.get(regionCode) : (String)regionNameMap.get(regionCode);
            setRegionName.accept(t, regionName);
        }
    }
}

