/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.minOrder;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingRegionPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingRegionRespVO;
import com.elitesland.scp.application.facade.vo.save.minOrder.ScpMinOrderSettingRegionSaveVO;
import com.elitesland.scp.domain.convert.minOrder.ScpMinOrderSettingRegionConvert;
import com.elitesland.scp.domain.entity.minOrder.ScpMinOrderSettingRegionDO;
import com.elitesland.scp.domain.service.minOrder.ScpMinOrderSettingRegionDomainService;
import com.elitesland.scp.infr.repo.minOrder.ScpMinOrderSettingRegionRepo;
import com.elitesland.scp.infr.repo.minOrder.ScpMinOrderSettingRegionRepoProc;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpMinOrderSettingRegionDomainServiceImpl
implements ScpMinOrderSettingRegionDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpMinOrderSettingRegionDomainServiceImpl.class);
    private final ScpMinOrderSettingRegionRepo scpMinOrderSettingRegionRepo;
    private final ScpMinOrderSettingRegionRepoProc scpMinOrderSettingRegionRepoProc;

    @Override
    public List<ScpMinOrderSettingRegionRespVO> findByMasId(Long masId) {
        List<ScpMinOrderSettingRegionDO> settingItemDOS = this.scpMinOrderSettingRegionRepo.findByMasId(masId);
        if (CollUtil.isNotEmpty(settingItemDOS)) {
            return ScpMinOrderSettingRegionConvert.INSTANCE.dosToRespVOS(settingItemDOS);
        }
        return new ArrayList<ScpMinOrderSettingRegionRespVO>();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSaveSettingRegion(List<ScpMinOrderSettingRegionSaveVO> saveVOS) {
        this.scpMinOrderSettingRegionRepo.saveAll(ScpMinOrderSettingRegionConvert.INSTANCE.saveVosDOS(saveVOS));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByMasId(Long masId) {
        this.scpMinOrderSettingRegionRepo.deleteByMasId(masId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpMinOrderSettingRegionRepo.deleteByIds(ids);
    }

    @Override
    public PagingVO<ScpMinOrderSettingRegionRespVO> page(ScpMinOrderSettingRegionPageParamVO paramVO) {
        long count = this.scpMinOrderSettingRegionRepoProc.countMinOrderSettingRegion(paramVO);
        if (count > 0L) {
            List<ScpMinOrderSettingRegionRespVO> respVOList = this.scpMinOrderSettingRegionRepoProc.queryMinOrderSettingRegion(paramVO);
            return new PagingVO(count, respVOList);
        }
        return new PagingVO();
    }

    @Override
    public List<Long> findMasIdByRegionCode(String regionCode) {
        return this.scpMinOrderSettingRegionRepoProc.findMasIdByRegionCode(regionCode);
    }

    public ScpMinOrderSettingRegionDomainServiceImpl(ScpMinOrderSettingRegionRepo scpMinOrderSettingRegionRepo, ScpMinOrderSettingRegionRepoProc scpMinOrderSettingRegionRepoProc) {
        this.scpMinOrderSettingRegionRepo = scpMinOrderSettingRegionRepo;
        this.scpMinOrderSettingRegionRepoProc = scpMinOrderSettingRegionRepoProc;
    }
}

