/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.scp.application.facade.vo.param.order.ScpComputeDemandOrderPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpsmanAuthQueryParam;
import com.elitesland.scp.application.facade.vo.resp.app.AppPayOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.AppDemandOrderCountRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderComputeVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderTitlePageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpPayOrderPageRespVO;
import com.elitesland.scp.domain.entity.authority.QScpsmanAuthorityDDO;
import com.elitesland.scp.domain.entity.authority.QScpsmanAuthorityDO;
import com.elitesland.scp.domain.entity.item.QScpCateItemDO;
import com.elitesland.scp.domain.entity.order.QScpDemandOrderDDO;
import com.elitesland.scp.domain.entity.order.QScpDemandOrderDO;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDO;
import com.elitesland.scp.domain.entity.scpsman.QScpsmanInfoDO;
import com.elitesland.scp.domain.entity.scpsman.QScpsmanRegionDO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;
import com.elitesland.scp.param.ScpDemandOrderRpcParam;
import com.elitesland.scp.utils.SysUtils;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class ScpDemandOrderRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QScpDemandOrderDO scpDemandOrderDO = QScpDemandOrderDO.scpDemandOrderDO;
    private final QScpDemandOrderDDO scpDemandOrderDDO = QScpDemandOrderDDO.scpDemandOrderDDO;
    private final QScpsmanRegionDO scpsmanRegionDO = QScpsmanRegionDO.scpsmanRegionDO;
    private final QScpCateItemDO scpCateItemDO = QScpCateItemDO.scpCateItemDO;
    private static final QScpsmanAuthorityDO scpsmanAuthorityDO = QScpsmanAuthorityDO.scpsmanAuthorityDO;
    private static final QScpsmanAuthorityDDO scpsmanAuthorityDDO = QScpsmanAuthorityDDO.scpsmanAuthorityDDO;
    private static final QScpsmanInfoDO scpsmanInfoDO = QScpsmanInfoDO.scpsmanInfoDO;
    private final QBean<ScpDemandOrderPageRespVO> pageList;
    private final QBean<ScpDemandOrderTitlePageRespVO> titlePageList;
    private final QBean<ScpDemandOrderDTO> demandOrderList;

    public long countDemandOrder(ScpDemandOrderPageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.scpDemandOrderDDO.count()).from((EntityPath)this.scpDemandOrderDDO)).leftJoin((EntityPath)this.scpDemandOrderDO)).on((Predicate)this.scpDemandOrderDO.id.eq(this.scpDemandOrderDDO.masId));
        Predicate predicateScpsmanAuth = this.appendScpsmanAuth(paramVO);
        if (predicateScpsmanAuth != null) {
            jpaQuery.where(predicateScpsmanAuth);
        }
        jpaQuery.where(this.whereDemandOrderPage(paramVO));
        return jpaQuery.fetchCount();
    }

    public long countDemandOrderPage(ScpDemandOrderPageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectDistinct((Expression)this.scpDemandOrderDDO.count()).from((EntityPath)this.scpDemandOrderDO)).leftJoin((EntityPath)this.scpDemandOrderDDO)).on((Predicate)this.scpDemandOrderDO.id.eq(this.scpDemandOrderDDO.masId));
        Predicate predicateScpsmanAuth = this.appendScpsmanAuth(paramVO);
        if (predicateScpsmanAuth != null) {
            jpaQuery.where(predicateScpsmanAuth);
        }
        jpaQuery.where(this.whereDemandOrderPage(paramVO));
        if (paramVO.getIsHeader().booleanValue()) {
            jpaQuery.groupBy(this.scpDemandOrderDO.id);
        }
        return jpaQuery.fetchCount();
    }

    private Predicate appendScpsmanAuth(ScpsmanAuthQueryParam queryParam) {
        BooleanExpression predicateRegionStore;
        if (Boolean.TRUE.equals(queryParam.getAllRegion())) {
            return null;
        }
        BooleanExpression predicateScpsmanRegion = this.scpDemandOrderDO.demandWhStCode.in((SubQueryExpression)JPAExpressions.select((Expression)this.scpsmanRegionDO.regionCode).from(new EntityPath[]{this.scpsmanRegionDO}).where(new Predicate[]{this.scpsmanRegionDO.masId.eq((Object)queryParam.getScpsmanInfoId()).and((Predicate)this.scpsmanRegionDO.regionType.eq((Object)com.elitesland.scp.application.enums.ScpUdcEnum.SCPSMAN_REGION_TYPE_STORE.getValueCode()))}));
        BooleanExpression booleanExpression = predicateRegionStore = CollUtil.isEmpty(queryParam.getRegionStoreCodes()) ? null : this.scpDemandOrderDO.demandWhStCode.in(queryParam.getRegionStoreCodes());
        if (predicateScpsmanRegion == null) {
            return predicateRegionStore;
        }
        return predicateRegionStore == null ? predicateScpsmanRegion : predicateScpsmanRegion.or((Predicate)predicateRegionStore);
    }

    public long countDemandOrderHeader(ScpDemandOrderPageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.scpDemandOrderDDO.count()).from((EntityPath)this.scpDemandOrderDO);
        jpaQuery.where(this.whereAppDemandOrderPage(paramVO));
        if (StrUtil.isNotBlank((CharSequence)paramVO.getKeyword()) || CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
            JPQLQuery subQuery = (JPQLQuery)JPAExpressions.selectOne().from(new EntityPath[]{this.scpDemandOrderDDO}).where(new Predicate[]{this.scpDemandOrderDO.id.eq(this.scpDemandOrderDDO.masId)});
            if (StrUtil.isNotBlank((CharSequence)paramVO.getKeyword())) {
                subQuery.where(new Predicate[]{this.scpDemandOrderDDO.itemCode.like(paramVO.getKeyword() + "%").or((Predicate)this.scpDemandOrderDDO.itemName.like("%" + paramVO.getKeyword() + "%"))});
            }
            jpaQuery.where((Predicate)subQuery.exists());
        }
        return jpaQuery.fetchCount();
    }

    public List<AppDemandOrderCountRespVO> countAppDemandOrder(ScpDemandOrderPageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.scpDemandOrderDO.docStatus, this.scpDemandOrderDO.count().as("count")}).from((EntityPath)this.scpDemandOrderDO);
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDocCode())) {
            jpaQuery.where((Predicate)this.scpDemandOrderDO.docCode.like(paramVO.getDocCode() + "%"));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDocStatus())) {
            jpaQuery.where((Predicate)this.scpDemandOrderDO.docStatus.eq((Object)paramVO.getDocStatus()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getDocStatusList())) {
            jpaQuery.where((Predicate)this.scpDemandOrderDO.docStatus.in(paramVO.getDocStatusList()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDemandWhStCode())) {
            jpaQuery.where((Predicate)this.scpDemandOrderDO.demandWhStCode.like(paramVO.getDemandWhStCode() + "%"));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getKeyword())) {
            BooleanExpression predicate = this.scpDemandOrderDDO.isNotNull();
            jpaQuery.where(ExpressionUtils.and((Predicate)predicate, (Predicate)this.scpDemandOrderDDO.itemCode.like(paramVO.getKeyword() + "%").or((Predicate)this.scpDemandOrderDDO.itemName.like("%" + paramVO.getKeyword() + "%"))));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
            jpaQuery.where((Predicate)this.scpDemandOrderDDO.itemCode.in(paramVO.getItemCodes()));
        }
        jpaQuery.groupBy((Expression)this.scpDemandOrderDO.docStatus);
        List tuples = jpaQuery.fetch();
        return tuples.stream().map(tuple -> {
            AppDemandOrderCountRespVO orderCountRespVO = new AppDemandOrderCountRespVO();
            orderCountRespVO.setDocStatus((String)tuple.get(0, String.class));
            orderCountRespVO.setCount((Long)tuple.get(1, Long.class));
            return orderCountRespVO;
        }).collect(Collectors.toList());
    }

    public List<ScpDemandOrderPageRespVO> queryDemandOrder(ScpDemandOrderPageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.pageList).from((EntityPath)this.scpDemandOrderDDO)).leftJoin((EntityPath)this.scpDemandOrderDO)).on((Predicate)this.scpDemandOrderDO.id.eq(this.scpDemandOrderDDO.masId));
        Predicate predicateScpsmanAuth = this.appendScpsmanAuth(paramVO);
        if (predicateScpsmanAuth != null) {
            jpaQuery.where(predicateScpsmanAuth);
        }
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, this.scpDemandOrderDDO);
        jpaQuery.where(this.whereDemandOrderPage(paramVO));
        return jpaQuery.fetch();
    }

    public List<Long> queryIdsByAccount(String account) {
        JPAQuery subQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(ScpDemandOrderRepoProc.scpsmanAuthorityDO.id).distinct()).from((EntityPath)scpsmanAuthorityDO)).leftJoin((EntityPath)scpsmanInfoDO)).on((Predicate)ScpDemandOrderRepoProc.scpsmanInfoDO.scpsmanNo.eq((Expression)ScpDemandOrderRepoProc.scpsmanAuthorityDO.scpsmanNo))).where((Predicate)ScpDemandOrderRepoProc.scpsmanAuthorityDO.enableStatus.eq(Boolean.TRUE).and((Predicate)ScpDemandOrderRepoProc.scpsmanInfoDO.loginAccount.eq((Object)account)));
        return subQuery.fetch();
    }

    public List<ScpDemandOrderTitlePageRespVO> queryDemandOrderPage(ScpDemandOrderPageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectDistinct(this.titlePageList).from((EntityPath)this.scpDemandOrderDO)).leftJoin((EntityPath)this.scpDemandOrderDDO)).on((Predicate)this.scpDemandOrderDO.id.eq(this.scpDemandOrderDDO.masId));
        Predicate predicateScpsmanStore = this.appendScpsmanAuth(paramVO);
        if (predicateScpsmanStore != null) {
            jpaQuery.where(predicateScpsmanStore);
        }
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, this.scpDemandOrderDO);
        jpaQuery.where(this.whereDemandOrderPage(paramVO));
        return jpaQuery.fetch();
    }

    public List<ScpDemandOrderPageRespVO> queryDemandOrderHeader(ScpDemandOrderPageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpDemandOrderPageRespVO.class, (Expression[])new Expression[]{this.scpDemandOrderDO.id, this.scpDemandOrderDO.type, this.scpDemandOrderDO.demandId, this.scpDemandOrderDO.demandCode, this.scpDemandOrderDO.demandName, this.scpDemandOrderDO.demandDate, this.scpDemandOrderDO.demandWhStId, this.scpDemandOrderDO.demandWhStCode, this.scpDemandOrderDO.demandWhStName, this.scpDemandOrderDO.demandDate, this.scpDemandOrderDO.storeType2, this.scpDemandOrderDO.docCode, this.scpDemandOrderDO.docCls, this.scpDemandOrderDO.docType, this.scpDemandOrderDO.docStatus, this.scpDemandOrderDO.payStatus, this.scpDemandOrderDO.apprStatus, this.scpDemandOrderDO.remark, this.scpDemandOrderDO.creator, this.scpDemandOrderDO.createTime, this.scpDemandOrderDO.replyFlag, this.scpDemandOrderDO.businessType, this.scpDemandOrderDO.etaDate, this.scpDemandOrderDO.payDateTime})).from((EntityPath)this.scpDemandOrderDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, this.scpDemandOrderDO);
        if (StrUtil.isNotBlank((CharSequence)paramVO.getKeyword()) || CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
            JPQLQuery subQuery = (JPQLQuery)JPAExpressions.selectOne().from(new EntityPath[]{this.scpDemandOrderDDO}).where(new Predicate[]{this.scpDemandOrderDO.id.eq(this.scpDemandOrderDDO.masId)});
            if (StrUtil.isNotBlank((CharSequence)paramVO.getKeyword())) {
                subQuery.where(new Predicate[]{this.scpDemandOrderDDO.itemCode.like(paramVO.getKeyword() + "%").or((Predicate)this.scpDemandOrderDDO.itemName.like("%" + paramVO.getKeyword() + "%"))});
            }
            jpaQuery.where((Predicate)subQuery.exists());
        }
        jpaQuery.where(this.whereAppDemandOrderPage(paramVO));
        return jpaQuery.fetch();
    }

    public List<ScpDemandOrderPageRespVO> sumDemandAmt(List<Long> masId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpDemandOrderPageRespVO.class, (Expression[])new Expression[]{this.scpDemandOrderDDO.masId.as("id"), ((NumberExpression)Expressions.cases().when((Predicate)this.scpDemandOrderDDO.projectFeeFlag.eq(Boolean.FALSE).or((Predicate)this.scpDemandOrderDDO.projectFeeFlag.isNull())).then(this.scpDemandOrderDDO.allocationDeQuantity).otherwise((Object)BigDecimal.ZERO)).sum().as("demandSumQuantity"), this.scpDemandOrderDDO.settlementSaleAmt.coalesce((Number)BigDecimal.ZERO).sum().as("demandSumAmt")})).from((EntityPath)this.scpDemandOrderDDO);
        jpaQuery.where((Predicate)this.scpDemandOrderDDO.masId.in(masId));
        jpaQuery.groupBy(this.scpDemandOrderDDO.masId);
        return jpaQuery.fetch();
    }

    public List<ScpDemandOrderDTO> findDemandOrderByParam(ScpDemandOrderParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.demandOrderList).from((EntityPath)this.scpDemandOrderDO);
        jpaQuery.where(this.whereDemandOrder(paramVO));
        return jpaQuery.fetch();
    }

    public List<ScpDemandOrderComputeVO> getItemAndWarehouseByIds(List<Long> ids) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpDemandOrderComputeVO.class, (Expression[])new Expression[]{this.scpDemandOrderDDO.id, this.scpDemandOrderDDO.itemId, this.scpDemandOrderDDO.itemCode, this.scpDemandOrderDDO.suppWhCode, this.scpDemandOrderDDO.suppWhId, this.scpDemandOrderDDO.demandQuantity, this.scpDemandOrderDDO.ouId, this.scpDemandOrderDDO.ouCode, this.scpDemandOrderDDO.allocationDeQuantity, this.scpDemandOrderDDO.planQuantity, this.scpDemandOrderDO.demandCode, this.scpDemandOrderDO.docCode, this.scpDemandOrderDO.demandWhStId, this.scpDemandOrderDO.demandWhStCode, this.scpDemandOrderDO.storeLevel, this.scpDemandOrderDO.businessType, this.scpDemandOrderDDO.unit})).from((EntityPath)this.scpDemandOrderDDO)).leftJoin((EntityPath)this.scpDemandOrderDO)).on((Predicate)this.scpDemandOrderDO.id.eq(this.scpDemandOrderDDO.masId));
        jpaQuery.where((Predicate)this.scpDemandOrderDO.id.in(ids));
        jpaQuery.where((Predicate)this.scpDemandOrderDDO.supplyType.eq((Object)ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode()));
        jpaQuery.where((Predicate)this.scpDemandOrderDDO.isCalculated.eq(Boolean.FALSE).and((Predicate)this.scpDemandOrderDDO.isPushed.eq(Boolean.FALSE)));
        return jpaQuery.fetch();
    }

    public List<ScpDemandOrderComputeVO> findDemandOrderInfo(Long demandId) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpDemandOrderComputeVO.class, (Expression[])new Expression[]{this.scpDemandOrderDDO.id, this.scpDemandOrderDDO.itemId, this.scpDemandOrderDDO.itemCode, this.scpDemandOrderDDO.suppWhCode, this.scpDemandOrderDDO.suppWhId, this.scpDemandOrderDDO.demandQuantity, this.scpDemandOrderDDO.allocationDeQuantity, this.scpDemandOrderDO.demandCode, this.scpDemandOrderDO.docCode, this.scpDemandOrderDO.storeLevel, this.scpDemandOrderDO.docStatus, this.scpDemandOrderDO.businessType, this.scpDemandOrderDDO.unit, this.scpDemandOrderDDO.isPushed, this.scpDemandOrderDDO.isCalculated})).from((EntityPath)this.scpDemandOrderDDO)).leftJoin((EntityPath)this.scpDemandOrderDO)).on((Predicate)this.scpDemandOrderDO.id.eq(this.scpDemandOrderDDO.masId));
        jpaQuery.where((Predicate)this.scpDemandOrderDO.demandId.eq((Object)demandId));
        return jpaQuery.fetch();
    }

    public List<ScpDemandOrderComputeVO> findDemandOrderById(Long id) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpDemandOrderComputeVO.class, (Expression[])new Expression[]{this.scpDemandOrderDDO.id, this.scpDemandOrderDDO.itemId, this.scpDemandOrderDDO.itemCode, this.scpDemandOrderDDO.suppWhCode, this.scpDemandOrderDDO.suppWhId, this.scpDemandOrderDDO.demandQuantity, this.scpDemandOrderDDO.allocationDeQuantity, this.scpDemandOrderDO.demandCode, this.scpDemandOrderDO.docCode, this.scpDemandOrderDO.storeLevel, this.scpDemandOrderDO.docStatus, this.scpDemandOrderDO.businessType, this.scpDemandOrderDO.allowPayTimeout, this.scpDemandOrderDDO.unit, this.scpDemandOrderDDO.isPushed, this.scpDemandOrderDDO.isCalculated})).from((EntityPath)this.scpDemandOrderDDO)).leftJoin((EntityPath)this.scpDemandOrderDO)).on((Predicate)this.scpDemandOrderDO.id.eq(this.scpDemandOrderDDO.masId));
        jpaQuery.where((Predicate)this.scpDemandOrderDO.id.eq((Object)id));
        return jpaQuery.fetch();
    }

    private Predicate whereAppDemandOrderPage(ScpDemandOrderPageParamVO paramVO) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDemandCode())) {
            predicates.add(this.scpDemandOrderDO.demandCode.like("%" + paramVO.getDemandCode() + "%"));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getType())) {
            predicates.add(this.scpDemandOrderDO.type.eq((Object)paramVO.getType()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDocCode())) {
            predicates.add(this.scpDemandOrderDO.docCode.like("%" + paramVO.getDocCode() + "%"));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDocStatus())) {
            predicates.add(this.scpDemandOrderDO.docStatus.eq((Object)paramVO.getDocStatus()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getDocStatusList())) {
            predicates.add(this.scpDemandOrderDO.docStatus.in(paramVO.getDocStatusList()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDemandWhStCode())) {
            predicates.add(this.scpDemandOrderDO.demandWhStCode.like("%" + paramVO.getDemandWhStCode() + "%"));
        }
        if (!ObjectUtils.isEmpty((Object)paramVO.getDemandDateFrom()) && !ObjectUtils.isEmpty((Object)paramVO.getDemandDateTo())) {
            predicates.add(this.scpDemandOrderDO.demandDate.between((Comparable)paramVO.getDemandDateFrom(), (Comparable)paramVO.getDemandDateTo()));
        }
        if (!ObjectUtils.isEmpty((Object)paramVO.getCreateTimeFrom()) && !ObjectUtils.isEmpty((Object)paramVO.getCreateTimeTo())) {
            predicates.add(this.scpDemandOrderDO.createTime.between((Comparable)paramVO.getCreateTimeFrom(), (Comparable)paramVO.getCreateTimeTo()));
        }
        if (CollUtil.isNotEmpty(paramVO.getDemandWhStCodes())) {
            predicates.add(this.scpDemandOrderDO.demandWhStCode.in(paramVO.getDemandWhStCodes()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getPayStatus())) {
            predicates.add(this.scpDemandOrderDO.payStatus.eq((Object)paramVO.getPayStatus()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDocType())) {
            predicates.add(this.scpDemandOrderDO.docType.eq((Object)paramVO.getDocType()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getBusinessType())) {
            predicates.add(this.scpDemandOrderDO.businessType.eq((Object)paramVO.getBusinessType()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getBusinessTypes())) {
            predicates.add(this.scpDemandOrderDO.businessType.in(paramVO.getBusinessTypes()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getPayStatusList())) {
            predicates.add(this.scpDemandOrderDO.payStatus.in(paramVO.getPayStatusList()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getDocTypeList())) {
            predicates.add(this.scpDemandOrderDO.docType.in(paramVO.getDocTypeList()));
        }
        if (paramVO.getReplyFlag() != null) {
            predicates.add(this.scpDemandOrderDO.replyFlag.eq(paramVO.getReplyFlag()));
        }
        if (paramVO.getApprStatus() != null) {
            predicates.add(this.scpDemandOrderDO.apprStatus.eq((Object)paramVO.getApprStatus()));
        }
        if (paramVO.getCreateUserId() != null) {
            predicates.add(this.scpDemandOrderDO.createUserId.eq((Object)paramVO.getCreateUserId()).or((Predicate)this.scpDemandOrderDO.createUserId.ne((Object)paramVO.getCreateUserId()).and((Predicate)this.scpDemandOrderDO.apprStatus.eq((Object)ScpUdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode())).and((Predicate)this.scpDemandOrderDO.docStatus.notIn((Object[])new String[]{ScpUdcEnum.DEO_STATUS_WT.getValueCode(), ScpUdcEnum.DEO_STATUS_DOING.getValueCode(), ScpUdcEnum.DEO_STATUS_DONE.getValueCode(), ScpUdcEnum.DEO_STATUS_PUSHING.getValueCode()}))));
        }
        return ExpressionUtils.allOf(predicates);
    }

    private Predicate whereDemandOrderPage(ScpDemandOrderPageParamVO paramVO) {
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDemandCode())) {
            predicates.add(this.scpDemandOrderDO.demandCode.like(paramVO.getDemandCode() + "%"));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getType())) {
            predicates.add(this.scpDemandOrderDO.type.eq((Object)paramVO.getType()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getBusinessType())) {
            predicates.add(this.scpDemandOrderDO.businessType.eq((Object)paramVO.getBusinessType()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDocCode())) {
            predicates.add(this.scpDemandOrderDO.docCode.like(paramVO.getDocCode() + "%"));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDocStatus())) {
            predicates.add(this.scpDemandOrderDO.docStatus.eq((Object)paramVO.getDocStatus()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getDocStatusList())) {
            predicates.add(this.scpDemandOrderDO.docStatus.in(paramVO.getDocStatusList()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDemandWhStCode())) {
            predicates.add(this.scpDemandOrderDO.demandWhStCode.like(paramVO.getDemandWhStCode() + "%"));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getKeyword())) {
            BooleanExpression predicate = this.scpDemandOrderDDO.isNotNull();
            predicates.add(ExpressionUtils.and((Predicate)predicate, (Predicate)this.scpDemandOrderDDO.itemCode.like(paramVO.getKeyword() + "%").or((Predicate)this.scpDemandOrderDDO.itemName.like("%" + paramVO.getKeyword() + "%"))));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
            predicates.add(this.scpDemandOrderDDO.itemCode.in(paramVO.getItemCodes()));
        }
        if (!ObjectUtils.isEmpty((Object)paramVO.getDemandDateFrom()) && !ObjectUtils.isEmpty((Object)paramVO.getDemandDateTo())) {
            predicates.add(this.scpDemandOrderDO.demandDate.between((Comparable)paramVO.getDemandDateFrom(), (Comparable)paramVO.getDemandDateTo()));
        }
        if (CollUtil.isNotEmpty(paramVO.getDemandWhStCodes())) {
            predicates.add(this.scpDemandOrderDO.demandWhStCode.in(paramVO.getDemandWhStCodes()));
        }
        if (CollUtil.isNotEmpty((Collection)paramVO.getIdSet())) {
            predicates.add(this.scpDemandOrderDDO.masId.add((Expression)this.scpDemandOrderDDO.id.coalesce((Number)0L)).in((Collection)paramVO.getIdSet()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getSuppWhCode())) {
            predicates.add(this.scpDemandOrderDDO.suppWhCode.eq((Object)paramVO.getSuppWhCode()));
        }
        if (CollUtil.isNotEmpty(paramVO.getSuppWhCodes())) {
            predicates.add(this.scpDemandOrderDDO.suppWhCode.in(paramVO.getSuppWhCodes()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getSupplyType())) {
            predicates.add(this.scpDemandOrderDDO.supplyType.eq((Object)paramVO.getSupplyType()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getPayStatus())) {
            predicates.add(this.scpDemandOrderDO.payStatus.eq((Object)paramVO.getPayStatus()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getApprStatus())) {
            predicates.add(this.scpDemandOrderDO.apprStatus.eq((Object)paramVO.getApprStatus()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDocType())) {
            predicates.add(this.scpDemandOrderDO.docType.eq((Object)paramVO.getDocType()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getPayStatusList())) {
            predicates.add(this.scpDemandOrderDO.payStatus.in(paramVO.getPayStatusList()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getDocTypeList())) {
            predicates.add(this.scpDemandOrderDO.docType.in(paramVO.getDocTypeList()));
        }
        if (paramVO.getReplyFlag() != null) {
            predicates.add(this.scpDemandOrderDO.replyFlag.eq(paramVO.getReplyFlag()));
        }
        if (!ObjectUtils.isEmpty((Object)paramVO.getCreateTimeFrom()) && !ObjectUtils.isEmpty((Object)paramVO.getCreateTimeTo())) {
            predicates.add(this.scpDemandOrderDO.createTime.between((Comparable)paramVO.getCreateTimeFrom(), (Comparable)paramVO.getCreateTimeTo()));
        }
        if (paramVO.getCreatorId() != null) {
            predicates.add(this.scpDemandOrderDO.createUserId.eq((Object)paramVO.getCreatorId()));
        }
        if (paramVO.getIsReceived() != null) {
            if (paramVO.getIsReceived().booleanValue()) {
                predicates.add(this.scpDemandOrderDDO.recvQty.goe(this.scpDemandOrderDDO.demandQuantity));
            } else {
                predicates.add(this.scpDemandOrderDDO.recvQty.isNull().or((Predicate)this.scpDemandOrderDDO.recvQty.lt(this.scpDemandOrderDDO.demandQuantity)));
            }
        }
        return ExpressionUtils.allOf(predicates);
    }

    private Predicate whereDemandOrder(ScpDemandOrderParamVO paramVO) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDemandCode())) {
            predicates.add(this.scpDemandOrderDO.demandCode.eq((Object)paramVO.getDemandCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getType())) {
            predicates.add(this.scpDemandOrderDO.type.eq((Object)paramVO.getType()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDocCode())) {
            predicates.add(this.scpDemandOrderDO.docCode.eq((Object)paramVO.getDocCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDocStatus())) {
            predicates.add(this.scpDemandOrderDO.docStatus.eq((Object)paramVO.getDocStatus()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDemandWhStCode())) {
            predicates.add(this.scpDemandOrderDO.demandWhStCode.eq((Object)paramVO.getDemandWhStCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDocType())) {
            predicates.add(this.scpDemandOrderDO.docType.eq((Object)paramVO.getDocType()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getBusinessType())) {
            predicates.add(this.scpDemandOrderDO.businessType.eq((Object)paramVO.getBusinessType()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public void updateOrderStatusByCode(String docCode, String status, Boolean isCalculated) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.scpDemandOrderDO).set((Path)this.scpDemandOrderDO.docStatus, (Object)status).where(new Predicate[]{this.scpDemandOrderDO.docCode.eq((Object)docCode)});
        if (isCalculated != null) {
            update.set((Path)this.scpDemandOrderDO.isCalculated, (Object)isCalculated);
        }
        update.execute();
    }

    public void updateOrderStatusById(Long id, String status, Boolean isPushed) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.scpDemandOrderDO).set((Path)this.scpDemandOrderDO.docStatus, (Object)status).where(new Predicate[]{this.scpDemandOrderDO.id.eq((Object)id)});
        if (isPushed != null) {
            update.set((Path)this.scpDemandOrderDO.isPushed, (Object)isPushed);
        }
        update.execute();
    }

    public void updateOrderStatusAndPushedTimeById(Long id, String status, Boolean isPushed, LocalDateTime pushedTime) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.scpDemandOrderDO).set((Path)this.scpDemandOrderDO.docStatus, (Object)status).where(new Predicate[]{this.scpDemandOrderDO.id.eq((Object)id)});
        if (isPushed != null) {
            update.set((Path)this.scpDemandOrderDO.isPushed, (Object)isPushed);
            update.set(this.scpDemandOrderDO.pushedTime, (Object)pushedTime);
        }
        update.execute();
    }

    public void updatePayStatusById(Long id, String status) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.scpDemandOrderDO).set((Path)this.scpDemandOrderDO.payStatus, (Object)status).where(new Predicate[]{this.scpDemandOrderDO.id.eq((Object)id)});
        update.execute();
    }

    public void updateOrderStatusAndPayStatusById(Long id, String status, String payStatus) {
        String orderSetting = SysUtils.getOrderSetting();
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.scpDemandOrderDO).set((Path)this.scpDemandOrderDO.docStatus, (Object)status).set((Path)this.scpDemandOrderDO.payStatus, (Object)payStatus).where(new Predicate[]{this.scpDemandOrderDO.id.eq((Object)id)});
        if ("1".equals(orderSetting)) {
            update.set((Path)this.scpDemandOrderDO.isCalculated, (Object)Boolean.TRUE);
        }
        update.execute();
    }

    public long countUnPushedItemByDemandId(Long demandId) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.scpDemandOrderDDO.count()).from((EntityPath)this.scpDemandOrderDDO)).leftJoin((EntityPath)this.scpDemandOrderDO)).on((Predicate)this.scpDemandOrderDO.id.eq(this.scpDemandOrderDDO.masId));
        jpaQuery.where((Predicate)this.scpDemandOrderDO.demandId.eq((Object)demandId));
        jpaQuery.where((Predicate)this.scpDemandOrderDDO.isPushed.eq(Boolean.FALSE).and((Predicate)this.scpDemandOrderDDO.isCalculated.eq(Boolean.TRUE)));
        return jpaQuery.fetchCount();
    }

    public List<ScpDemandOrderDO> findByDemandWhStCodeInAndByCreateTime(List<String> collect, LocalDateTime fromTime, LocalDateTime toTime) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.scpDemandOrderDO).from((EntityPath)this.scpDemandOrderDO);
        if (CollectionUtil.isNotEmpty(collect)) {
            jpaQuery.where((Predicate)this.scpDemandOrderDO.demandWhStCode.in(collect));
        }
        if (fromTime != null) {
            jpaQuery.where((Predicate)this.scpDemandOrderDO.createTime.goe((Comparable)fromTime));
        }
        if (toTime != null) {
            jpaQuery.where((Predicate)this.scpDemandOrderDO.createTime.loe((Comparable)toTime));
        }
        return jpaQuery.fetch();
    }

    public long countDemandOrderByDemandIds(List<Long> demandIds) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.scpDemandOrderDO.count()).from((EntityPath)this.scpDemandOrderDO);
        jpaQuery.where((Predicate)this.scpDemandOrderDO.demandId.in(demandIds));
        return jpaQuery.fetchCount();
    }

    public List<ScpDemandOrderComputeVO> findComputeDemandOrderDByParam(List<Long> orderIds) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpDemandOrderComputeVO.class, (Expression[])new Expression[]{this.scpDemandOrderDDO.id, this.scpDemandOrderDDO.itemId, this.scpDemandOrderDDO.itemCode, this.scpDemandOrderDDO.suppWhCode, this.scpDemandOrderDDO.suppWhId, this.scpDemandOrderDDO.demandQuantity, this.scpDemandOrderDDO.ouId, this.scpDemandOrderDDO.ouCode, this.scpDemandOrderDDO.allocationDeQuantity, this.scpDemandOrderDDO.planQuantity, this.scpDemandOrderDO.demandCode, this.scpDemandOrderDO.docCode, this.scpDemandOrderDO.demandWhStId, this.scpDemandOrderDO.demandWhStCode, this.scpDemandOrderDO.storeLevel, this.scpDemandOrderDO.businessType, this.scpDemandOrderDDO.unit})).from((EntityPath)this.scpDemandOrderDDO)).leftJoin((EntityPath)this.scpDemandOrderDO)).on((Predicate)this.scpDemandOrderDO.id.eq(this.scpDemandOrderDDO.masId));
        jpaQuery.where((Predicate)this.scpDemandOrderDO.id.in(orderIds));
        jpaQuery.where((Predicate)this.scpDemandOrderDDO.isCalculated.eq(Boolean.FALSE).and((Predicate)this.scpDemandOrderDDO.isPushed.eq(Boolean.FALSE)));
        return jpaQuery.fetch();
    }

    public List<Long> pageDemandOrderIds(ScpComputeDemandOrderPageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.scpDemandOrderDO.id).from((EntityPath)this.scpDemandOrderDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, this.scpDemandOrderDO);
        jpaQuery.where((Predicate)this.scpDemandOrderDO.demandId.eq((Object)paramVO.getDemandId()));
        return jpaQuery.fetch();
    }

    public long countAppPayPage(ScpDemandOrderPageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.scpDemandOrderDDO.count()).from((EntityPath)this.scpDemandOrderDDO)).leftJoin((EntityPath)this.scpDemandOrderDO)).on((Predicate)this.scpDemandOrderDO.id.eq(this.scpDemandOrderDDO.masId));
        if (StrUtil.isNotBlank((CharSequence)paramVO.getPayStatus())) {
            jpaQuery.where((Predicate)this.scpDemandOrderDDO.payStatus.eq((Object)paramVO.getPayStatus()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDemandWhStCode())) {
            jpaQuery.where((Predicate)this.scpDemandOrderDO.demandWhStCode.eq((Object)paramVO.getDemandWhStCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getType())) {
            jpaQuery.where((Predicate)this.scpDemandOrderDO.type.eq((Object)paramVO.getType()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getKeyword())) {
            jpaQuery.where((Predicate)this.scpDemandOrderDDO.itemCode.like(paramVO.getKeyword() + "%").or((Predicate)this.scpDemandOrderDDO.itemName.like("%" + paramVO.getKeyword() + "%")));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
            jpaQuery.where((Predicate)this.scpDemandOrderDDO.itemCode.in(paramVO.getItemCodes()));
        }
        if (!ObjectUtils.isEmpty((Object)paramVO.getDemandDateFrom()) && !ObjectUtils.isEmpty((Object)paramVO.getDemandDateTo())) {
            jpaQuery.where((Predicate)this.scpDemandOrderDO.demandDate.between((Comparable)paramVO.getDemandDateFrom(), (Comparable)paramVO.getDemandDateTo()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getDocTypeList())) {
            jpaQuery.where((Predicate)this.scpDemandOrderDO.docType.in(paramVO.getDocTypeList()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDocCode())) {
            jpaQuery.where((Predicate)this.scpDemandOrderDO.docCode.like(paramVO.getDocCode() + "%"));
        }
        if (CollUtil.isNotEmpty(paramVO.getPayStatusList())) {
            jpaQuery.where((Predicate)this.scpDemandOrderDDO.payStatus.in(paramVO.getPayStatusList()));
        }
        jpaQuery.where((Predicate)this.scpDemandOrderDO.docStatus.eq((Object)ScpUdcEnum.DEO_STATUS_PUSHED.getValueCode()));
        jpaQuery.where((Predicate)this.scpDemandOrderDDO.srcDocId.isNotNull());
        jpaQuery.groupBy((Expression)this.scpDemandOrderDDO.srcDocNo);
        return jpaQuery.fetchCount();
    }

    public List<ScpPayOrderPageRespVO> payPage(ScpDemandOrderPageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpPayOrderPageRespVO.class, (Expression[])new Expression[]{this.scpDemandOrderDDO.srcDocCls, this.scpDemandOrderDDO.srcDocId, this.scpDemandOrderDDO.srcDocNo, this.scpDemandOrderDDO.saleOuName, this.scpDemandOrderDDO.saleOuCode, this.scpDemandOrderDDO.masId.as("docId"), this.scpDemandOrderDDO.payStatus, this.scpDemandOrderDDO.planAmt.sum().as("amt")})).from((EntityPath)this.scpDemandOrderDDO)).leftJoin((EntityPath)this.scpDemandOrderDO)).on((Predicate)this.scpDemandOrderDO.id.eq(this.scpDemandOrderDDO.masId));
        paramVO.setPaging(jpaQuery);
        if (StrUtil.isNotBlank((CharSequence)paramVO.getPayStatus())) {
            jpaQuery.where((Predicate)this.scpDemandOrderDDO.payStatus.eq((Object)paramVO.getPayStatus()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDemandWhStCode())) {
            jpaQuery.where((Predicate)this.scpDemandOrderDO.demandWhStCode.eq((Object)paramVO.getDemandWhStCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getKeyword())) {
            jpaQuery.where((Predicate)this.scpDemandOrderDDO.itemCode.like(paramVO.getKeyword() + "%").or((Predicate)this.scpDemandOrderDDO.itemName.like("%" + paramVO.getKeyword() + "%")));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
            jpaQuery.where((Predicate)this.scpDemandOrderDDO.itemCode.in(paramVO.getItemCodes()));
        }
        if (!ObjectUtils.isEmpty((Object)paramVO.getDemandDateFrom()) && !ObjectUtils.isEmpty((Object)paramVO.getDemandDateTo())) {
            jpaQuery.where((Predicate)this.scpDemandOrderDO.demandDate.between((Comparable)paramVO.getDemandDateFrom(), (Comparable)paramVO.getDemandDateTo()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getDocTypeList())) {
            jpaQuery.where((Predicate)this.scpDemandOrderDO.docType.in(paramVO.getDocTypeList()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getType())) {
            jpaQuery.where((Predicate)this.scpDemandOrderDO.type.eq((Object)paramVO.getType()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDocCode())) {
            jpaQuery.where((Predicate)this.scpDemandOrderDO.docCode.like(paramVO.getDocCode() + "%"));
        }
        if (CollUtil.isNotEmpty(paramVO.getPayStatusList())) {
            jpaQuery.where((Predicate)this.scpDemandOrderDDO.payStatus.in(paramVO.getPayStatusList()));
        }
        jpaQuery.where((Predicate)this.scpDemandOrderDO.docStatus.eq((Object)ScpUdcEnum.DEO_STATUS_PUSHED.getValueCode()));
        jpaQuery.where((Predicate)this.scpDemandOrderDDO.srcDocId.isNotNull());
        jpaQuery.groupBy(new Expression[]{this.scpDemandOrderDDO.srcDocNo, this.scpDemandOrderDDO.masId, this.scpDemandOrderDDO.srcDocCls, this.scpDemandOrderDDO.srcDocId, this.scpDemandOrderDDO.payStatus, this.scpDemandOrderDDO.saleOuCode, this.scpDemandOrderDDO.saleOuName});
        jpaQuery.orderBy(this.scpDemandOrderDDO.masId.desc());
        return jpaQuery.fetch();
    }

    public List<ScpPayOrderPageRespVO> findDemandOrderByIds(List<Long> ids) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpPayOrderPageRespVO.class, (Expression[])new Expression[]{this.scpDemandOrderDO.id.as("docId"), this.scpDemandOrderDO.docCode, this.scpDemandOrderDO.docCls, this.scpDemandOrderDO.docType, this.scpDemandOrderDO.docStatus, this.scpDemandOrderDO.createTime, this.scpDemandOrderDO.businessType})).from((EntityPath)this.scpDemandOrderDO);
        jpaQuery.where((Predicate)this.scpDemandOrderDO.id.in(ids));
        return jpaQuery.fetch();
    }

    public AppPayOrderRespVO findPayOrderBySrcDocId(Long srcDocId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AppPayOrderRespVO.class, (Expression[])new Expression[]{this.scpDemandOrderDDO.srcDocCls, this.scpDemandOrderDDO.srcDocId, this.scpDemandOrderDDO.srcDocNo, this.scpDemandOrderDDO.saleOuCode, this.scpDemandOrderDDO.saleOuName, this.scpDemandOrderDDO.masId.as("docId"), this.scpDemandOrderDDO.payStatus, this.scpDemandOrderDDO.onlinePayFlag, this.scpDemandOrderDDO.payerName})).from((EntityPath)this.scpDemandOrderDDO);
        jpaQuery.where((Predicate)this.scpDemandOrderDDO.srcDocId.eq((Object)srcDocId));
        jpaQuery.groupBy(new Expression[]{this.scpDemandOrderDDO.srcDocNo, this.scpDemandOrderDDO.masId, this.scpDemandOrderDDO.srcDocCls, this.scpDemandOrderDDO.srcDocId, this.scpDemandOrderDDO.payStatus, this.scpDemandOrderDDO.saleOuCode, this.scpDemandOrderDDO.saleOuName, this.scpDemandOrderDDO.onlinePayFlag, this.scpDemandOrderDDO.payerName});
        return (AppPayOrderRespVO)jpaQuery.fetchOne();
    }

    public List<AppPayOrderRespVO> findPayOrderById(Long id) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AppPayOrderRespVO.class, (Expression[])new Expression[]{this.scpDemandOrderDDO.srcDocCls, this.scpDemandOrderDDO.srcDocId, this.scpDemandOrderDDO.srcDocNo, this.scpDemandOrderDDO.saleOuCode, this.scpDemandOrderDDO.saleOuName, this.scpDemandOrderDDO.masId.as("docId"), this.scpDemandOrderDDO.payStatus, this.scpDemandOrderDDO.onlinePayFlag, this.scpDemandOrderDDO.payerName})).from((EntityPath)this.scpDemandOrderDDO);
        jpaQuery.where((Predicate)this.scpDemandOrderDDO.masId.eq((Object)id));
        jpaQuery.groupBy(new Expression[]{this.scpDemandOrderDDO.srcDocNo, this.scpDemandOrderDDO.masId, this.scpDemandOrderDDO.srcDocCls, this.scpDemandOrderDDO.srcDocId, this.scpDemandOrderDDO.payStatus, this.scpDemandOrderDDO.saleOuCode, this.scpDemandOrderDDO.saleOuName, this.scpDemandOrderDDO.onlinePayFlag, this.scpDemandOrderDDO.payerName});
        return jpaQuery.fetch();
    }

    public Long countAppOrderByParam(ScpDemandOrderPageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.scpDemandOrderDO.count()).from((EntityPath)this.scpDemandOrderDO)).where(this.whereAppDemandOrderPage(paramVO));
        if (StrUtil.isNotBlank((CharSequence)paramVO.getKeyword()) || CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
            JPQLQuery subQuery = (JPQLQuery)JPAExpressions.selectOne().from(new EntityPath[]{this.scpDemandOrderDDO}).where(new Predicate[]{this.scpDemandOrderDO.id.eq(this.scpDemandOrderDDO.masId)});
            if (StrUtil.isNotBlank((CharSequence)paramVO.getKeyword())) {
                subQuery.where(new Predicate[]{this.scpDemandOrderDDO.itemCode.like(paramVO.getKeyword() + "%").or((Predicate)this.scpDemandOrderDDO.itemName.like("%" + paramVO.getKeyword() + "%"))});
            }
            if (CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
                subQuery.where(new Predicate[]{this.scpDemandOrderDDO.itemCode.in(paramVO.getItemCodes())});
            }
            jpaQuery.where((Predicate)subQuery.exists());
        }
        return (Long)jpaQuery.fetchOne();
    }

    public String getOrderTypeById(Long id) {
        return (String)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.scpDemandOrderDO.type).from((EntityPath)this.scpDemandOrderDO)).where((Predicate)this.scpDemandOrderDO.id.eq((Object)id))).fetchOne();
    }

    public Long countUnReply(Long storeId, LocalDateTime dateTime) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.scpDemandOrderDO.count()).from((EntityPath)this.scpDemandOrderDO)).where((Predicate)this.scpDemandOrderDO.demandWhStId.eq((Object)storeId));
        jpaQuery.where((Predicate)this.scpDemandOrderDO.docStatus.eq((Object)ScpUdcEnum.DEO_STATUS_RECV.getValueCode()));
        jpaQuery.where((Predicate)this.scpDemandOrderDO.replyFlag.eq(Boolean.FALSE));
        jpaQuery.where((Predicate)this.scpDemandOrderDO.createTime.goe((Comparable)dateTime));
        return jpaQuery.fetchCount();
    }

    public void updateAccAmt(ScpDemandOrderRpcParam param) {
        JPAUpdateClause updateClause = this.jpaQueryFactory.update((EntityPath)this.scpDemandOrderDO).where(new Predicate[]{this.scpDemandOrderDO.id.eq((Object)param.getId())});
        if (param.getCreditAccAmt() != null) {
            updateClause.set(this.scpDemandOrderDO.creditAccAmt, (Object)param.getCreditAccAmt());
        }
        if (param.getFlzhAccAmt() != null) {
            updateClause.set(this.scpDemandOrderDO.flzhAccAmt, (Object)param.getFlzhAccAmt());
        }
        if (param.getStoreAccAmt() != null) {
            updateClause.set(this.scpDemandOrderDO.storeAccAmt, (Object)param.getStoreAccAmt());
        }
        updateClause.execute();
    }

    public Map<Long, BigDecimal> countAllocatedOrderItemByItemCodes(List<Long> itemIds, String storeCode, LocalDateTime dateTime) {
        LocalDateTime startTime = dateTime.with(LocalTime.MIN);
        LocalDateTime endTime = dateTime.with(LocalTime.MAX);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.scpDemandOrderDDO.itemId, this.scpDemandOrderDDO.demandQuantity.sum()}).from((EntityPath)this.scpDemandOrderDDO)).leftJoin((EntityPath)this.scpDemandOrderDO)).on((Predicate)this.scpDemandOrderDO.id.eq(this.scpDemandOrderDDO.masId))).where((Predicate)this.scpDemandOrderDDO.itemId.in(itemIds))).where((Predicate)this.scpDemandOrderDO.demandWhStCode.eq((Object)storeCode))).where((Predicate)this.scpDemandOrderDO.docStatus.eq((Object)ScpUdcEnum.DEO_STATUS_PUSHED.getValueCode()))).where((Predicate)this.scpDemandOrderDDO.createTime.goe((Comparable)startTime).and((Predicate)this.scpDemandOrderDDO.createTime.loe((Comparable)endTime)))).groupBy(this.scpDemandOrderDDO.itemId);
        return jpaQuery.fetch().stream().collect(Collectors.toMap(tuple -> (Long)tuple.get(0, Long.class), tuple -> (BigDecimal)tuple.get(1, BigDecimal.class)));
    }

    public Long countAllocatedOrderByItemCodes(String storeCode, String activeCode, LocalDateTime startTime, LocalDateTime endTime) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.scpDemandOrderDO.id.countDistinct()).from((EntityPath)this.scpDemandOrderDDO)).leftJoin((EntityPath)this.scpDemandOrderDO)).on((Predicate)this.scpDemandOrderDO.id.eq(this.scpDemandOrderDDO.masId))).where((Predicate)this.scpDemandOrderDDO.activityCode.eq((Object)activeCode))).where((Predicate)this.scpDemandOrderDO.demandWhStCode.eq((Object)storeCode))).where((Predicate)this.scpDemandOrderDO.docStatus.notIn((Object[])new String[]{ScpUdcEnum.DEO_STATUS_CLOSE.getValueCode(), ScpUdcEnum.DEO_STATUS_DRAFT.getValueCode(), ScpUdcEnum.DEO_STATUS_TIMEOUT.getValueCode()}))).where((Predicate)this.scpDemandOrderDDO.createTime.goe((Comparable)startTime).and((Predicate)this.scpDemandOrderDDO.createTime.loe((Comparable)endTime)))).groupBy((Expression)this.scpDemandOrderDDO.activityCode);
        return (Long)jpaQuery.fetchOne();
    }

    public List<String> countAllocatedOrderByStoreCode(String storeCode) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectDistinct((Expression)this.scpDemandOrderDO.docCode).from((EntityPath)this.scpDemandOrderDO)).innerJoin((EntityPath)this.scpDemandOrderDDO)).on((Predicate)this.scpDemandOrderDO.id.eq(this.scpDemandOrderDDO.masId).and((Predicate)this.scpDemandOrderDDO.activityCode.isNotNull()))).where((Predicate)this.scpDemandOrderDO.demandWhStCode.eq((Object)storeCode))).where((Predicate)this.scpDemandOrderDO.docStatus.notIn((Object[])new String[]{ScpUdcEnum.DEO_STATUS_CLOSE.getValueCode(), ScpUdcEnum.DEO_STATUS_DRAFT.getValueCode(), ScpUdcEnum.DEO_STATUS_TIMEOUT.getValueCode()}))).where((Predicate)this.scpDemandOrderDO.payStatus.eq((Object)ScpUdcEnum.PAY_STATUS_WAIT_PAY.getValueCode()))).where((Predicate)this.scpDemandOrderDO.businessType.eq((Object)ScpUdcEnum.BUSINESS_TYPE_40.getValueCode()));
        return jpaQuery.fetch();
    }

    public Map<String, Long> countAllocatedOrderByStoreCodeList(List<String> storeCodeList, String activeCode, LocalDateTime startTime, LocalDateTime endTime) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.scpDemandOrderDO.demandWhStCode, this.scpDemandOrderDO.id.countDistinct()}).from((EntityPath)this.scpDemandOrderDDO)).leftJoin((EntityPath)this.scpDemandOrderDO)).on((Predicate)this.scpDemandOrderDO.id.eq(this.scpDemandOrderDDO.masId))).where((Predicate)this.scpDemandOrderDDO.activityCode.eq((Object)activeCode))).where((Predicate)this.scpDemandOrderDO.demandWhStCode.in(storeCodeList))).where((Predicate)this.scpDemandOrderDO.docStatus.notIn((Object[])new String[]{ScpUdcEnum.DEO_STATUS_CLOSE.getValueCode(), ScpUdcEnum.DEO_STATUS_DRAFT.getValueCode()}))).where((Predicate)this.scpDemandOrderDDO.createTime.goe((Comparable)startTime).and((Predicate)this.scpDemandOrderDDO.createTime.loe((Comparable)endTime)))).groupBy((Expression)this.scpDemandOrderDO.demandWhStCode);
        return jpaQuery.fetch().stream().collect(Collectors.toMap(tuple -> (String)tuple.get(0, String.class), tuple -> (Long)tuple.get(1, Long.class)));
    }

    public void updatePayStatus(ScpDemandOrderRpcParam param) {
        JPAUpdateClause updateClause = this.jpaQueryFactory.update((EntityPath)this.scpDemandOrderDO).set((Path)this.scpDemandOrderDO.payStatus, (Object)param.getPayStatus());
        if (StrUtil.isNotBlank((CharSequence)param.getDocCode())) {
            updateClause.where(new Predicate[]{this.scpDemandOrderDO.docCode.eq((Object)param.getDocCode())});
        }
        if (param.getId() != null) {
            updateClause.where(new Predicate[]{this.scpDemandOrderDO.id.eq((Object)param.getId())});
        }
        if (param.getPayDateTime() != null) {
            updateClause.set(this.scpDemandOrderDO.payDateTime, (Object)param.getPayDateTime());
        }
        updateClause.execute();
    }

    public void updateOrderStatusById(Long id, String docStatus) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.scpDemandOrderDO).set((Path)this.scpDemandOrderDO.docStatus, (Object)docStatus).where(new Predicate[]{this.scpDemandOrderDO.id.eq((Object)id)});
        update.execute();
    }

    public Long findIdByCode(String docCode) {
        return (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.scpDemandOrderDO.id).from((EntityPath)this.scpDemandOrderDO)).where((Predicate)this.scpDemandOrderDO.docCode.eq((Object)docCode))).fetchOne();
    }

    public List<String> findCodeByPayStatus(String payStatus) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.scpDemandOrderDO.docCode).from((EntityPath)this.scpDemandOrderDO)).where((Predicate)this.scpDemandOrderDO.payStatus.eq((Object)payStatus))).fetch();
    }

    public Boolean existRecvOrderByTroId(Long troId) {
        return !((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.scpDemandOrderDDO.id).from((EntityPath)this.scpDemandOrderDDO)).where((Predicate)this.scpDemandOrderDDO.srcDocId.eq((Object)troId).and((Predicate)this.scpDemandOrderDDO.recvQty.gt((Number)BigDecimal.ZERO)))).fetch().isEmpty();
    }

    public ScpDemandOrderRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.pageList = Projections.bean(ScpDemandOrderPageRespVO.class, (Expression[])new Expression[]{this.scpDemandOrderDO.id, this.scpDemandOrderDO.type, this.scpDemandOrderDO.demandId, this.scpDemandOrderDO.demandCode, this.scpDemandOrderDO.demandName, this.scpDemandOrderDO.demandDate, this.scpDemandOrderDO.demandWhStId, this.scpDemandOrderDO.demandWhStCode, this.scpDemandOrderDO.demandWhStName, this.scpDemandOrderDO.demandDate, this.scpDemandOrderDO.storeType2, this.scpDemandOrderDO.docCode, this.scpDemandOrderDO.docType, this.scpDemandOrderDO.docCls, this.scpDemandOrderDO.docStatus, this.scpDemandOrderDO.remark, this.scpDemandOrderDO.businessType, this.scpDemandOrderDDO.id.as("detailId"), this.scpDemandOrderDDO.sourceId, this.scpDemandOrderDDO.supplyType, this.scpDemandOrderDDO.itemCode, this.scpDemandOrderDDO.itemId, this.scpDemandOrderDDO.itemName, this.scpDemandOrderDDO.demandQuantity, this.scpDemandOrderDDO.allocationDeQuantity, this.scpDemandOrderDDO.unit, this.scpDemandOrderDDO.unitName, this.scpDemandOrderDDO.price, this.scpDemandOrderDDO.currency, this.scpDemandOrderDDO.allocationQuantity, this.scpDemandOrderDDO.planQuantity, this.scpDemandOrderDDO.suppWhId, this.scpDemandOrderDDO.suppWhCode, this.scpDemandOrderDDO.suppWhName, this.scpDemandOrderDDO.ouId, this.scpDemandOrderDDO.ouCode, this.scpDemandOrderDDO.ouName, this.scpDemandOrderDDO.srcDocId, this.scpDemandOrderDDO.srcDocNo, this.scpDemandOrderDDO.srcDocCls, this.scpDemandOrderDDO.srcDocLineNo, this.scpDemandOrderDDO.quantity, this.scpDemandOrderDDO.isPushed, this.scpDemandOrderDDO.isCalculated, this.scpDemandOrderDDO.creator, this.scpDemandOrderDDO.createTime, this.scpDemandOrderDDO.createUserId, this.scpDemandOrderDDO.modifyTime, this.scpDemandOrderDDO.modifyUserId, this.scpDemandOrderDDO.updater, this.scpDemandOrderDDO.syncMsg, this.scpDemandOrderDDO.remark.as("ddRemark"), this.scpDemandOrderDDO.uom2, this.scpDemandOrderDDO.uom2Name, this.scpDemandOrderDDO.qty2, this.scpDemandOrderDDO.saleOuCode, this.scpDemandOrderDDO.saleOuName, this.scpDemandOrderDDO.payStatus, this.scpDemandOrderDDO.lineNo, this.scpDemandOrderDDO.settlementPrice, this.scpDemandOrderDDO.settlementAmt, this.scpDemandOrderDDO.recvQty, this.scpDemandOrderDDO.returnQty, this.scpDemandOrderDDO.compensateQty, this.scpDemandOrderDDO.deliveryType, this.scpDemandOrderDDO.costType, this.scpDemandOrderDDO.imgUrl});
        this.titlePageList = Projections.bean(ScpDemandOrderTitlePageRespVO.class, (Expression[])new Expression[]{this.scpDemandOrderDO.id, this.scpDemandOrderDO.type, this.scpDemandOrderDO.demandId, this.scpDemandOrderDO.demandCode, this.scpDemandOrderDO.demandName, this.scpDemandOrderDO.demandDate, this.scpDemandOrderDO.demandWhStId, this.scpDemandOrderDO.demandWhStCode, this.scpDemandOrderDO.demandWhStName, this.scpDemandOrderDO.demandDate, this.scpDemandOrderDO.storeType2, this.scpDemandOrderDO.docCode, this.scpDemandOrderDO.docCls, this.scpDemandOrderDO.docStatus, this.scpDemandOrderDO.apprStatus, this.scpDemandOrderDO.remark, this.scpDemandOrderDO.payStatus, this.scpDemandOrderDO.docType, this.scpDemandOrderDO.createTime, this.scpDemandOrderDO.creator, this.scpDemandOrderDO.updater, this.scpDemandOrderDO.modifyTime, this.scpDemandOrderDO.isCalculated, this.scpDemandOrderDO.isPushed, this.scpDemandOrderDO.businessType, this.scpDemandOrderDO.etaDate, this.scpDemandOrderDO.payDateTime});
        this.demandOrderList = Projections.bean(ScpDemandOrderDTO.class, (Expression[])new Expression[]{this.scpDemandOrderDO.id, this.scpDemandOrderDO.type, this.scpDemandOrderDO.demandId, this.scpDemandOrderDO.demandCode, this.scpDemandOrderDO.demandName, this.scpDemandOrderDO.demandDate, this.scpDemandOrderDO.demandWhStId, this.scpDemandOrderDO.demandWhStCode, this.scpDemandOrderDO.demandWhStName, this.scpDemandOrderDO.demandDate, this.scpDemandOrderDO.docType, this.scpDemandOrderDO.storeType2, this.scpDemandOrderDO.docCode, this.scpDemandOrderDO.docCls, this.scpDemandOrderDO.docStatus, this.scpDemandOrderDO.businessType});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

