/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.mq;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitesland.scp.boh.StoreReceiveApproveSendParam;
import com.elitesland.scp.dto.order.ScpDemandOrderDRpcDTO;
import com.elitesland.scp.provider.order.ScpDemandOrderDRpcServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class StoreReceiveApproveListener
implements MessageQueueListener<StoreReceiveApproveSendParam> {
    private static final Logger log = LoggerFactory.getLogger(StoreReceiveApproveListener.class);
    private final ScpDemandOrderDRpcServiceImpl scpDemandOrderDRpcServiceImpl;

    @NotEmpty
    public String[] channels() {
        return new String[]{"store_order_approve"};
    }

    @Transactional(rollbackFor={Exception.class})
    public void onConsume(@NotBlank String s, @NotNull StoreReceiveApproveSendParam storeReceiveSendParam) {
        log.info("\u56de\u5199\u95e8\u5e97\u6536\u8d27\u5355\u5ba1\u6279\u6570\u91cf\uff1a" + JSON.toJSONString((Object)storeReceiveSendParam));
        if (CollectionUtil.isEmpty((Collection)storeReceiveSendParam.getOrderDocs())) {
            return;
        }
    }

    private List<ScpDemandOrderDRpcDTO> prepareCallbackParam(StoreReceiveApproveSendParam storeReceiveSendParam) {
        ArrayList<ScpDemandOrderDRpcDTO> rpcDTOS = new ArrayList<ScpDemandOrderDRpcDTO>();
        storeReceiveSendParam.getOrderDocs().forEach(item -> {
            Long docId = item.getDocId();
            String docNO = item.getDocNo();
            List orderItems = item.getItems();
            Map<Long, List<StoreReceiveApproveSendParam.OrderItem>> data = StoreReceiveApproveListener.orderDidGroup(orderItems);
            Map<Long, String> lineNoMap = StoreReceiveApproveListener.processLineNo(orderItems);
            Map<Long, BigDecimal> qtyMap = StoreReceiveApproveListener.processQty(orderItems);
            data.keySet().forEach(orderDid -> {
                ScpDemandOrderDRpcDTO rpcDto = new ScpDemandOrderDRpcDTO();
                rpcDto.setId(orderDid);
                rpcDto.setMasId(item.getOrderId());
                rpcDto.setSrcDocId(docId);
                rpcDto.setSrcDocNo(docNO);
                rpcDto.setSrcDocCls("STKTRN");
                rpcDto.setSrcDocLineNo((String)lineNoMap.get(orderDid));
                rpcDto.setAllocationQuantity((BigDecimal)qtyMap.get(orderDid));
                rpcDTOS.add(rpcDto);
            });
        });
        log.info("rpcDTOS\u7684\u503c:{}", (Object)JSONUtil.toJsonStr(rpcDTOS));
        return rpcDTOS;
    }

    public static Map<Long, List<StoreReceiveApproveSendParam.OrderItem>> orderDidGroup(List<StoreReceiveApproveSendParam.OrderItem> orderItems) {
        return orderItems.stream().collect(Collectors.groupingBy(StoreReceiveApproveSendParam.OrderItem::getOrderDid));
    }

    public static Map<Long, String> processLineNo(List<StoreReceiveApproveSendParam.OrderItem> orderItems) {
        return orderItems.stream().collect(Collectors.groupingBy(StoreReceiveApproveSendParam.OrderItem::getOrderDid, Collectors.mapping(e -> String.valueOf(e.getLineNo()), Collectors.joining(","))));
    }

    public static Map<Long, BigDecimal> processQty(List<StoreReceiveApproveSendParam.OrderItem> orderItems) {
        return orderItems.stream().collect(Collectors.groupingBy(StoreReceiveApproveSendParam.OrderItem::getOrderDid, Collectors.mapping(StoreReceiveApproveSendParam.OrderItem::getQty, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
    }

    public StoreReceiveApproveListener(ScpDemandOrderDRpcServiceImpl scpDemandOrderDRpcServiceImpl) {
        this.scpDemandOrderDRpcServiceImpl = scpDemandOrderDRpcServiceImpl;
    }
}

