/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.provider.order;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.domain.convert.order.ScpDemandOrderConvert;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.dto.order.ScpDemandOrderRpcDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepoProc;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepoProc;
import com.elitesland.scp.param.ScpDemandOrderRpcParam;
import com.elitesland.scp.service.order.ScpDemandOrderRpcService;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"/rpc/scp/orderRpc"})
public class ScpDemandOrderRpcServiceImpl
implements ScpDemandOrderRpcService {
    private static final Logger log = LoggerFactory.getLogger(ScpDemandOrderRpcServiceImpl.class);
    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final ScpDemandOrderRepoProc scpDemandOrderRepoProc;
    private final ScpDemandOrderDRepoProc scpDemandOrderDRepoProc;

    public ApiResult<ScpDemandOrderRpcDTO> findById(Long id) {
        if (id == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Optional<ScpDemandOrderDTO> orderOptional = this.scpDemandOrderDomainService.findDemandOrderById(id);
        if (orderOptional.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8ba2\u8d27\u5355\u4e0d\u5b58\u5728");
        }
        return ApiResult.ok((Object)ScpDemandOrderConvert.INSTANCE.dto2RpcDTO(orderOptional.get()));
    }

    @Transactional
    public ApiResult<Long> updateAccAmt(ScpDemandOrderRpcParam param) {
        if (param == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getId() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getCreditAccAmt() == null && param.getFlzhAccAmt() == null && param.getStoreAccAmt() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8ba2\u8d27\u5355\u8d26\u6237\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a");
        }
        this.scpDemandOrderRepoProc.updateAccAmt(param);
        return ApiResult.ok((Object)param.getId());
    }

    @Transactional
    public ApiResult<Object> updatePayStatus(ScpDemandOrderRpcParam param) {
        log.info("\u66f4\u65b0\u8ba2\u8d27\u5355\u652f\u4ed8\u72b6\u6001\u5f00\u59cb\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
        if (param.getId() == null && StringUtils.isBlank((CharSequence)param.getDocCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8ba2\u8d27\u5355id\u548c\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (param.getId() == null) {
            Long id = this.scpDemandOrderRepoProc.findIdByCode(param.getDocCode());
            if (id == null) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8ba2\u8d27\u5355\u4e0d\u5b58\u5728");
            }
            param.setId(id);
        }
        this.scpDemandOrderRepoProc.updatePayStatus(param);
        this.scpDemandOrderDRepoProc.updatePayStatusByMasId(param.getId(), param.getPayStatus());
        log.info("\u66f4\u65b0\u8ba2\u8d27\u5355\u652f\u4ed8\u72b6\u6001\u7ed3\u675f");
        return ApiResult.ok();
    }

    public ApiResult<List<String>> findCodeByPayStatus(String payStatus) {
        log.info("\u6839\u636e\u652f\u4ed8\u72b6\u6001\u67e5\u8be2\u8ba2\u8d27\u5355\u5f00\u59cb\uff1a{}", (Object)payStatus);
        if (StringUtils.isBlank((CharSequence)payStatus)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u652f\u4ed8\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.info("\u6839\u636e\u652f\u4ed8\u72b6\u6001\u67e5\u8be2\u8ba2\u8d27\u5355\u7ed3\u675f\uff1a{}", (Object)payStatus);
        return ApiResult.ok(this.scpDemandOrderRepoProc.findCodeByPayStatus(payStatus));
    }

    public ApiResult<Boolean> autoRecvFlag(Long troId) {
        if (this.scpDemandOrderRepoProc.existRecvOrderByTroId(troId).booleanValue()) {
            return ApiResult.ok((Object)false);
        }
        return ApiResult.ok((Object)true);
    }

    public ScpDemandOrderRpcServiceImpl(ScpDemandOrderDomainService scpDemandOrderDomainService, ScpDemandOrderRepoProc scpDemandOrderRepoProc, ScpDemandOrderDRepoProc scpDemandOrderDRepoProc) {
        this.scpDemandOrderDomainService = scpDemandOrderDomainService;
        this.scpDemandOrderRepoProc = scpDemandOrderRepoProc;
        this.scpDemandOrderDRepoProc = scpDemandOrderDRepoProc;
    }
}

