package com.elitesland.scp.application.service.storeProtocol;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.domain.service.article.ArticleManageService;
import com.elitesland.scp.service.StoreProtocolRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 *
 * Created by lance on 2025/11/11.
 */
@Slf4j
@Service
@RestController
@RequiredArgsConstructor
@RequestMapping(ScpApplication.URI_PREFIX + StoreProtocolRpcService.PATH)
public class StoreProtocolRpcServiceImpl implements StoreProtocolRpcService {

    private final ArticleManageService articleManageService;

    @Override
    public String searchStoreProtocolByName(String categoryName) {
        try {
            return articleManageService.queryAppStoreProtocolArticle(categoryName);
        } catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException(ApiCode.FAIL, "查询门店协议信息异常");
        }
    }
}
