package com.elitesland.scp.application.web.mrp;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpMrpPageParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpRespVO;
import com.elitesland.scp.application.service.mrp.ScpMrpService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@Api(tags = "物料需求计划")
@RestController
@RequestMapping(value = "/mrp", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class ScpMrpController {

    private final ScpMrpService scpMrpService;

    @ApiOperation(value = "物料需求计划 - 分页查询")
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<ScpMrpRespVO>> page(@RequestBody ScpMrpPageParam param) {
        log.info("[SCP-MRP] page  param ={}", JSONUtil.toJsonStr(param));
        return ApiResult.ok(scpMrpService.page(param));
    }

    @PutMapping("/delete")
    @ApiOperation("物料需求计划 - 删除")
    public ApiResult deleteByIds(@RequestBody List<Long> ids) {
        log.info("[SCP-MRP] delete  param ={}", JSONUtil.toJsonStr(ids));
        scpMrpService.deleteByIds(ids);
        return ApiResult.ok();
    }

    @ApiOperation(value = "物料需求计划 - 计算")
    @PostMapping(value = "/compute/{predId}")
    public ApiResult<Object> compute(@PathVariable Long predId) {
        log.info("[SCP-MRP] compute  param ={}", predId);
        scpMrpService.compute(predId);
        return ApiResult.ok();
    }

    @ApiOperation(value = "物料需求计划 - 推送采购订单")
    @PostMapping(value = "/pushPo/{id}")
    public ApiResult<Object> pushPo(@PathVariable Long id) {
        log.info("[SCP-MRP] pushPo  param ={}", id);
        scpMrpService.pushPo(id);
        return ApiResult.ok();
    }
}
