package com.elitesland.scp.domain.entity.survey;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serial;
import java.io.Serializable;

@Entity
@Table(name = "scp_survey_publish", indexes = {
})
@Comment("问卷")
@Getter
@Setter
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class SurveyPublishDO extends BaseModel implements Serializable {
    @Serial
    private static final long serialVersionUID = -4254921460115216468L;

    @ApiModelProperty("问卷ID")
    @Column(name = "suv_id")
    private Long suvId;

    @ApiModelProperty("公司ID")
    @Column(name = "ou_id")
    private Long ouId;

    @ApiModelProperty("公司编码")
    @Column(name = "ou_code")
    private String ouCode;

    @ApiModelProperty("公司名称")
    @Column(name = "ou_name")
    private String ouName;

    @ApiModelProperty("填写状态(1填写，0未填写)")
    @Column(name = "fill_status")
    private String fillStatus;



}
