package com.elitesland.scp.infr.repo.item;

import com.elitesland.scp.domain.entity.item.ScpCateItemSaleScopeStoreDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;
import java.util.List;

public interface ScpCateItemSaleScopeStoreRepo extends JpaRepository<ScpCateItemSaleScopeStoreDO, Long>, QuerydslPredicateExecutor<ScpCateItemSaleScopeStoreDO> {


    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "delete from scp_cate_item_sale_scope_store where mas_id in ?1", nativeQuery = true)
    void deleteByMasIdIn(Collection<Long> masIdList);


    List<ScpCateItemSaleScopeStoreDO> findAllByMasId(Long masId);

    List<ScpCateItemSaleScopeStoreDO> findAllByMasIdAndVisibleStatus(Long masId, Boolean visibleStatus);

    List<ScpCateItemSaleScopeStoreDO> findAllByMasIdIn(List<Long> masIdList);

    List<ScpCateItemSaleScopeStoreDO> findAllByMasIdInAndStoreCode(Collection<Long> masId, String storeCode);

    List<ScpCateItemSaleScopeStoreDO> findAllByMasIdInAndStoreCodeIn(Collection<Long> masId, Collection<String> storeCodes);

    // 根据masId和storeCode删除数据
    @Transactional
    @Modifying
    @Query(value = "delete from scp_cate_item_sale_scope_store where mas_id = ?1 and store_code in ?2", nativeQuery = true)
    void deleteByMasIdAndStoreCodeList(Long masId, List<String> storeCodeList);
}
