package com.elitesland.scp.rmi;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.core.yst.common.SysSettingCacheService;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.system.service.SysSettingService;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Slf4j
@Component
@RequiredArgsConstructor
public class RmiSysSettingService {

    private final SysSettingCacheService sysSettingCacheService;

    public SysSettingVO findSysSettingByNo(String no) {
        log.info("查询系统设置表数据：param= " + no);
        try {
            SysSettingVO sysSettingVO = sysSettingCacheService.getSysSetting(no);
            log.info("查询系统设置表数据：result= " + JSONUtil.toJsonStr(sysSettingVO));
            return sysSettingVO;
        } catch (Exception e) {
            log.error("查询系统设置表数据:{}", e);
            throw new BusinessException(ApiCode.FAIL, "查询系统设置表数据接口异常:" + e);
        }
    }
}
