package com.elitesland.scp.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Auther: Mark
 * @Date: 2024/5/14 14:45
 * @Description: 封装一些高频Stream表达式操作
 */
public class StreamHelper {

    public static <T, K> List<T> distinctByKey(List<T> list, Function<? super T, K> keyExtractor) {
        Map<K, T> map = list.stream()
                .collect(Collectors.toMap(keyExtractor, Function.identity(), (existing, replacement) -> existing));
        return new ArrayList<>(map.values());
    }
}
