package com.elitesland.scp.utils.excel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.RowWriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;


public class ExcelWriteUtil {

    /**
     * 获取输出流
     * @param response
     * @param filename  导出文件名
     * @return
     * @throws IOException
     */
    public OutputStream getOutputStream(HttpServletResponse response, String filename) throws IOException {
        OutputStream outputStream = response.getOutputStream();
        response.reset();
        filename = URLEncoder.encode(filename, StandardCharsets.UTF_8);
        response.setHeader("Content-disposition", "attachment; filename=" + filename + ".xlsx");
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/x-download");
        /*response.setContentType("application/msexcel;charset=UTF-8");//设置类型
        response.setHeader("Pragma", "No-cache");//设置头
        response.setHeader("Cache-Control", "no-cache");//设置头
        response.setDateHeader("Expires", 0);//设置日期头*/
        return outputStream;
    }


    /**
     * @param response  响应
     * @param list      出参数据集
     * @param clazz     出参对象类型
     * @param fileName  excel 文件名称
     * @param sheetName excel Sheet页名称
     */
    public static void autoAliasExcelWrite(HttpServletResponse response,
                                  List<?> list,
                                  Class<?> clazz,
                                  String fileName,
                                  String sheetName
                                  ) throws IOException {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8);
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        RowWriteHandler aliasRowWriteHandler = new AliasRowWriteHandle();
        ExcelWriterBuilder write = EasyExcel.write(response.getOutputStream(), clazz);
        write.registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .registerWriteHandler(aliasRowWriteHandler)
                .sheet(sheetName).doWrite(list);
    }


    public static void autoPredictStStockAliasExcelWrite(HttpServletResponse response,
                                           List<?> list,
                                           Class<?> clazz,
                                           String fileName,
                                           String sheetName
    ) throws IOException {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8);
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        RowWriteHandler aliasRowWriteHandler = new StStockAliasRowWriteHandle();
        ExcelWriterBuilder write = EasyExcel.write(response.getOutputStream(), clazz);
        write.registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .registerWriteHandler(aliasRowWriteHandler)
                .sheet(sheetName).doWrite(list);
    }



}


