/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.authority;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.inv.dto.invwh.InvWhDetailRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcDtoParam;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.facade.vo.save.authority.ScpManAuthorityDSaveVO;
import com.elitesland.scp.application.facade.vo.save.authority.ScpManAuthorityImportVO;
import com.elitesland.scp.application.facade.vo.save.authority.ScpManAuthoritySaveVO;
import com.elitesland.scp.application.service.authority.ScpsmanAuthorityService;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepo;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class ScpsmanAuthprityImportImpl
implements DataImport<ScpManAuthorityImportVO> {
    private static final Logger log = LoggerFactory.getLogger(ScpsmanAuthprityImportImpl.class);
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u89e3\u6790\u5f02\u5e38: {2}; ";
    private final ScpsmanAuthorityService scpsmanAuthorityService;
    private final ScpsmanInfoRepo scpsmanInfoRepo;
    private final RmiInvStkRpcService rmiInvStkService;
    private final RmiOrgStoreRpcService rmiOrgStoreService;
    private final TaskExecutor taskExecutor;

    public Set<Integer> sheetNoList() {
        return Collections.singleton(1);
    }

    public Integer stepSize() {
        return 5000;
    }

    public String getTmplCode() {
        return "yst_scpsman_authority_import";
    }

    public List<String> executeImport(List<ScpManAuthorityImportVO> dataList, int startRowIndex) {
        if (CollUtil.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        log.info("\u8ba1\u5212\u5458\u6743\u9650\u5bfc\u5165\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(dataList));
        ArrayList<String> errors = new ArrayList<String>(dataList.size());
        try {
            return this.checkAndSaveData(dataList, startRowIndex);
        }
        catch (Exception e) {
            log.error("\u8ba1\u5212\u5458\u6743\u9650\u5bfc\u5165\u5f02\u5e38\uff1a", (Throwable)e);
            for (ScpManAuthorityImportVO entity : dataList) {
                errors.add(e.getMessage());
            }
            return errors;
        }
    }

    private List<String> checkAndSaveData(List<ScpManAuthorityImportVO> dataList, int startRowIndex) throws Exception {
        if (CollUtil.isEmpty(dataList)) {
            log.error("\u8ba1\u5212\u5458\u6743\u9650\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
            return Lists.newArrayList();
        }
        CompletableFuture<List> completeInvWhDetailRpcDTOS = CompletableFuture.supplyAsync(() -> this.whQuery(dataList), (Executor)this.taskExecutor);
        CompletableFuture<List> completeOrgStoreDetailRpcDTOS = CompletableFuture.supplyAsync(() -> this.storeQuery(dataList), (Executor)this.taskExecutor);
        CompletableFuture<List> completeScpsmanInfoList = CompletableFuture.supplyAsync(() -> this.queryScpsman(dataList), (Executor)this.taskExecutor);
        CompletableFuture<List> completableScpsmanAuthorityList = CompletableFuture.supplyAsync(() -> this.queryByScpsmanAuthority(dataList), (Executor)this.taskExecutor);
        Map<String, List<ScpManAuthorityImportVO>> scpMap = dataList.stream().collect(Collectors.groupingBy(data -> data.getScpsmanNo() + data.getTypeName() + data.getStWhCode()));
        List invWhDetailRpcDTOS = completeInvWhDetailRpcDTOS.get();
        List orgStoreDetailRpcDTOS = completeOrgStoreDetailRpcDTOS.get();
        List scpsmanInfoDOS = completeScpsmanInfoList.get();
        List scpsmanAuthorityDOS = completableScpsmanAuthorityList.get();
        Map<String, List<ScpManAuthorityPageRespVO>> scpsmanAuthorityMap = scpsmanAuthorityDOS.stream().collect(Collectors.groupingBy(data -> data.getScpsmanNo() + data.getTypeName() + data.getStWhCode()));
        ArrayList<String> errorList = new ArrayList<String>();
        for (ScpManAuthorityImportVO t : dataList) {
            Optional<Object> first;
            Object errorLog = new String();
            if (StringUtils.isBlank((CharSequence)t.getScpsmanNo())) {
                errorLog = MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u8ba1\u5212\u5458\u7f16\u7801", "\u8ba1\u5212\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)t.getTypeName())) {
                errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u7c7b\u578b", "\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isNotBlank((CharSequence)t.getTypeName()) && !Objects.equals(t.getTypeName(), "\u4ed3\u5e93") && !Objects.equals(t.getTypeName(), "\u95e8\u5e97")) {
                errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u7c7b\u578b", "\u975e\u4ed3\u5e93/\u95e8\u5e97");
            }
            if (StringUtils.isBlank((CharSequence)t.getStWhCode())) {
                errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u95e8\u5e97\u7f16\u7801/\u4ed3\u5e93\u7f16\u7801", "\u95e8\u5e97\u7f16\u7801/\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)t.getEnableStatusName())) {
                errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u542f\u7528\u72b6\u6001", "\u542f\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isNotBlank((CharSequence)t.getEnableStatusName()) && !Objects.equals(t.getEnableStatusName(), "\u542f\u7528") && !Objects.equals(t.getEnableStatusName(), "\u7981\u7528")) {
                errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u542f\u7528\u72b6\u6001", "\u975e\u542f\u7528/\u7981\u7528");
            }
            if (CollectionUtil.isNotEmpty((Collection)invWhDetailRpcDTOS) && StringUtils.isNotBlank((CharSequence)t.getStWhCode())) {
                first = invWhDetailRpcDTOS.stream().filter(n -> n.getWhCode().equals(t.getStWhCode())).findFirst();
                if (first.isPresent() && Objects.equals(first.get().getWhStatus(), ScpUdcEnum.WH_STATUS_CLOSED.getValueCode())) {
                    errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u95e8\u5e97\u7f16\u7801/\u4ed3\u5e93\u7f16\u7801", "\u4ed3\u5e93\u5df2\u505c\u7528");
                }
                if (!first.isPresent() && Objects.equals(t.getTypeName(), "\u4ed3\u5e93")) {
                    errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u95e8\u5e97\u7f16\u7801/\u4ed3\u5e93\u7f16\u7801", "\u4ed3\u5e93\u4e0d\u5b58\u5728");
                }
            } else if (StringUtils.isNotBlank((CharSequence)t.getTypeName()) && Objects.equals(t.getTypeName(), "\u4ed3\u5e93")) {
                errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u95e8\u5e97\u7f16\u7801/\u4ed3\u5e93\u7f16\u7801", "\u4ed3\u5e93\u4e0d\u5b58\u5728");
            }
            if (CollectionUtil.isNotEmpty((Collection)orgStoreDetailRpcDTOS) && StringUtils.isNotBlank((CharSequence)t.getStWhCode())) {
                first = orgStoreDetailRpcDTOS.stream().filter(n -> n.getStoreCode().equals(t.getStWhCode())).findFirst();
                if (first.isPresent() && Objects.equals(((OrgStoreDetailRpcDTO)first.get()).getStoreStatus(), "CLOSED")) {
                    errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u95e8\u5e97\u7f16\u7801/\u4ed3\u5e93\u7f16\u7801", "\u95e8\u5e97\u662f\u95ed\u5e97\u72b6\u6001");
                }
                if (!first.isPresent() && Objects.equals(t.getTypeName(), "\u95e8\u5e97")) {
                    errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u95e8\u5e97\u7f16\u7801/\u4ed3\u5e93\u7f16\u7801", "\u95e8\u5e97\u4e0d\u5b58\u5728");
                }
            } else if (StringUtils.isNotBlank((CharSequence)t.getTypeName()) && Objects.equals(t.getTypeName(), "\u95e8\u5e97")) {
                errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u95e8\u5e97\u7f16\u7801/\u4ed3\u5e93\u7f16\u7801", "\u95e8\u5e97\u4e0d\u5b58\u5728");
            }
            if (CollectionUtil.isNotEmpty((Collection)scpsmanInfoDOS) && StringUtils.isNotBlank((CharSequence)t.getScpsmanNo())) {
                first = scpsmanInfoDOS.stream().filter(n -> n.getScpsmanNo().equals(t.getScpsmanNo())).findFirst();
                if (first.isPresent() && ((ScpsmanInfoDO)((Object)first.get())).getEnableStatus() != 1) {
                    errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u8ba1\u5212\u5458\u72b6\u6001\u4e0d\u662f\u542f\u7528\u72b6\u6001");
                }
                if (first.isPresent() && StringUtils.isNotBlank((CharSequence)t.getOuName()) && !Objects.equals(t.getOuName(), ((ScpsmanInfoDO)((Object)first.get())).getOuName())) {
                    errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u6240\u5c5e\u516c\u53f8\u4e0d\u662f\u5f53\u524d\u8ba1\u5212\u5458\u6240\u5c5e\u516c\u53f8\u6570\u636e");
                }
                if (!first.isPresent()) {
                    errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u8ba1\u5212\u5458\u4e0d\u5b58\u5728");
                }
            } else {
                errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u8ba1\u5212\u5458\u4e0d\u5b58\u5728");
            }
            String checkMessage = t.getScpsmanNo() + t.getTypeName() + t.getStWhCode();
            if (MapUtils.isNotEmpty(scpMap) && scpMap.get(checkMessage) != null && scpMap.get(checkMessage).size() > 1) {
                errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u5b58\u5728\u591a\u884c\u91cd\u590d\u6570\u636e");
            }
            if (MapUtils.isNotEmpty(scpsmanAuthorityMap) && scpsmanAuthorityMap.get(checkMessage) != null && scpsmanAuthorityMap.get(checkMessage).size() >= 1) {
                errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u6570\u636e\u5e93\u5df2\u5b58\u5728\u6b64\u6570\u636e");
            }
            errorList.add((String)(StringUtils.isNotBlank((CharSequence)errorLog) ? errorLog : null));
            ++startRowIndex;
        }
        if (CollectionUtil.isNotEmpty(errorList) && !errorList.stream().allMatch(element -> element == null)) {
            return errorList;
        }
        this.createScpsmanAuthority(dataList, invWhDetailRpcDTOS, orgStoreDetailRpcDTOS, scpsmanInfoDOS, scpsmanAuthorityDOS);
        return null;
    }

    private void createScpsmanAuthority(List<ScpManAuthorityImportVO> dataList, List<InvWhDetailRpcDTO> invWhDetailRpcDTOS, List<OrgStoreDetailRpcDTO> orgStoreDetailRpcDTOS, List<ScpsmanInfoDO> byScpsmanNoIn, List<ScpManAuthorityPageRespVO> scpsmanAuthorityDOS) {
        HashMap scpmanAuthorityMap = CollectionUtil.isNotEmpty(scpsmanAuthorityDOS) ? scpsmanAuthorityDOS.stream().collect(Collectors.groupingBy(ScpManAuthorityPageRespVO::getScpsmanNo)) : new HashMap();
        Map<String, List<ScpManAuthorityImportVO>> scpMap = dataList.stream().collect(Collectors.groupingBy(data -> data.getScpsmanNo() + data.getScpsman() + data.getOuName()));
        if (!MapUtils.isNotEmpty(scpMap)) {
            throw new BusinessException("\u5bfc\u5165\u5206\u7ec4\u96c6\u5408\u4e3a\u7a7a");
        }
        ArrayList scpManAuthoritySaveVOS = new ArrayList();
        scpMap.keySet().stream().forEach(k -> {
            List scpManAuthorityPageRespVOS;
            Long id = null;
            List scpManAuthorityImportVOS = (List)scpMap.get(k);
            ScpManAuthorityImportVO scpManAuthorityImportVO = (ScpManAuthorityImportVO)scpManAuthorityImportVOS.get(0);
            ScpManAuthoritySaveVO scpManAuthoritySaveVO = new ScpManAuthoritySaveVO();
            ArrayList<ScpManAuthorityDSaveVO> scpManAuthorityDSaveVOList = new ArrayList<ScpManAuthorityDSaveVO>();
            scpManAuthoritySaveVO.setScpsmanNo(scpManAuthorityImportVO.getScpsmanNo());
            scpManAuthoritySaveVO.setEnableStatus("\u542f\u7528".equals(scpManAuthorityImportVO.getEnableStatusName()));
            if (CollectionUtil.isNotEmpty((Collection)byScpsmanNoIn)) {
                Optional<ScpsmanInfoDO> first = byScpsmanNoIn.stream().filter(n -> n.getScpsmanNo().equals(scpManAuthorityImportVO.getScpsmanNo())).findFirst();
                scpManAuthoritySaveVO.setScpsmanId(first.get().getId());
                scpManAuthoritySaveVO.setScpsmanName(first.get().getName());
                scpManAuthoritySaveVO.setOuName(first.get().getOuName());
                scpManAuthoritySaveVO.setOuCode(first.get().getOuCode());
                scpManAuthoritySaveVO.setOuId(first.get().getOuId());
            }
            if (MapUtils.isNotEmpty((Map)scpmanAuthorityMap) && CollectionUtil.isNotEmpty((Collection)(scpManAuthorityPageRespVOS = (List)scpmanAuthorityMap.get(scpManAuthorityImportVO.getScpsmanNo())))) {
                ScpManAuthorityPageRespVO scpManAuthorityPageRespVO = (ScpManAuthorityPageRespVO)scpManAuthorityPageRespVOS.get(0);
                id = scpManAuthorityPageRespVO.getId();
                scpManAuthorityPageRespVOS.stream().forEach(scp -> {
                    ScpManAuthorityDSaveVO scpManAuthorityDSaveVO = new ScpManAuthorityDSaveVO();
                    scpManAuthorityDSaveVO.setType(scp.getType());
                    scpManAuthorityDSaveVO.setMasId(scpManAuthorityPageRespVO.getId());
                    scpManAuthorityDSaveVO.setStWhId(scp.getStWhId());
                    scpManAuthorityDSaveVO.setStWhName(scp.getStWhName());
                    scpManAuthorityDSaveVO.setStWhCode(scp.getStWhCode());
                    scpManAuthorityDSaveVOList.add(scpManAuthorityDSaveVO);
                });
            }
            scpManAuthorityImportVOS.stream().forEach(scp -> {
                Optional<OrgStoreDetailRpcDTO> first;
                ScpManAuthorityDSaveVO scpManAuthorityDSaveVO = new ScpManAuthorityDSaveVO();
                scpManAuthorityDSaveVO.setType("\u95e8\u5e97".equals(scp.getTypeName()) ? 0 : ("\u4ed3\u5e93".equals(scp.getTypeName()) ? Integer.valueOf(1) : null));
                if ("\u95e8\u5e97".equals(scp.getTypeName()) && CollectionUtil.isNotEmpty((Collection)orgStoreDetailRpcDTOS)) {
                    first = orgStoreDetailRpcDTOS.stream().filter(n -> n.getStoreCode().equals(scp.getStWhCode())).findFirst();
                    scpManAuthorityDSaveVO.setStWhId(first.isPresent() ? first.get().getId() : null);
                    scpManAuthorityDSaveVO.setStWhCode(first.isPresent() ? first.get().getStoreCode() : null);
                    scpManAuthorityDSaveVO.setStWhName(first.isPresent() ? first.get().getStoreName() : null);
                    scpManAuthorityDSaveVO.setRegion(first.isPresent() ? first.get().getRegion() : null);
                }
                if ("\u4ed3\u5e93".equals(scp.getTypeName()) && CollectionUtil.isNotEmpty((Collection)invWhDetailRpcDTOS)) {
                    first = invWhDetailRpcDTOS.stream().filter(n -> n.getWhCode().equals(scp.getStWhCode())).findFirst();
                    scpManAuthorityDSaveVO.setStWhId(first.isPresent() ? ((InvWhDetailRpcDTO)first.get()).getId() : null);
                    scpManAuthorityDSaveVO.setStWhCode(first.isPresent() ? ((InvWhDetailRpcDTO)first.get()).getWhCode() : null);
                    scpManAuthorityDSaveVO.setStWhName(first.isPresent() ? ((InvWhDetailRpcDTO)first.get()).getWhName() : null);
                    scpManAuthorityDSaveVO.setRegion(first.isPresent() ? ((InvWhDetailRpcDTO)first.get()).getRegion() : null);
                }
                scpManAuthorityDSaveVOList.add(scpManAuthorityDSaveVO);
            });
            scpManAuthoritySaveVO.setId(id == null ? null : id);
            scpManAuthoritySaveVO.setScpManAuthorityDSaveVOS(scpManAuthorityDSaveVOList);
            scpManAuthoritySaveVOS.add(scpManAuthoritySaveVO);
        });
        scpManAuthoritySaveVOS.stream().forEach(auth -> this.scpsmanAuthorityService.saveScpAuthority((ScpManAuthoritySaveVO)auth));
    }

    private List<OrgStoreDetailRpcDTO> storeQuery(List<ScpManAuthorityImportVO> dataList) {
        List<String> scpsmanNoList = dataList.stream().filter(wh -> Objects.nonNull(wh.getTypeName())).filter(t -> t.getTypeName().equals("\u95e8\u5e97")).map(ScpManAuthorityImportVO::getStWhCode).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(scpsmanNoList)) {
            return null;
        }
        return this.rmiOrgStoreService.queryByStoreCodes(scpsmanNoList);
    }

    private List<InvWhDetailRpcDTO> whQuery(List<ScpManAuthorityImportVO> dataList) {
        InvWhRpcDtoParam invWhRpcDtoParam = new InvWhRpcDtoParam();
        List scpsmanNoList = dataList.stream().filter(wh -> Objects.nonNull(wh.getTypeName())).filter(t -> t.getTypeName().equals("\u4ed3\u5e93")).map(ScpManAuthorityImportVO::getStWhCode).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(scpsmanNoList)) {
            return null;
        }
        invWhRpcDtoParam.setWhCodes(scpsmanNoList);
        List<InvWhDetailRpcDTO> data = this.rmiInvStkService.findWhAreaDTOByParam(invWhRpcDtoParam);
        return data;
    }

    private List<ScpsmanInfoDO> queryScpsman(List<ScpManAuthorityImportVO> dataList) {
        List<String> scpsmanNoList = dataList.stream().filter(wh -> Objects.nonNull(wh.getScpsmanNo())).filter(t -> Objects.nonNull(t.getScpsmanNo())).map(ScpManAuthorityImportVO::getScpsmanNo).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(scpsmanNoList)) {
            return null;
        }
        return this.scpsmanInfoRepo.findByScpsmanNoIn(scpsmanNoList);
    }

    private List<ScpManAuthorityPageRespVO> queryByScpsmanAuthority(List<ScpManAuthorityImportVO> dataList) {
        List<String> scpsmanNoList = dataList.stream().filter(wh -> Objects.nonNull(wh.getScpsmanNo())).filter(t -> Objects.nonNull(t.getScpsmanNo())).map(ScpManAuthorityImportVO::getScpsmanNo).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(scpsmanNoList)) {
            return null;
        }
        return this.scpsmanAuthorityService.findByScpsmanNoIn(scpsmanNoList);
    }

    public ScpsmanAuthprityImportImpl(ScpsmanAuthorityService scpsmanAuthorityService, ScpsmanInfoRepo scpsmanInfoRepo, RmiInvStkRpcService rmiInvStkService, RmiOrgStoreRpcService rmiOrgStoreService, TaskExecutor taskExecutor) {
        this.scpsmanAuthorityService = scpsmanAuthorityService;
        this.scpsmanInfoRepo = scpsmanInfoRepo;
        this.rmiInvStkService = rmiInvStkService;
        this.rmiOrgStoreService = rmiOrgStoreService;
        this.taskExecutor = taskExecutor;
    }
}

