/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.pay.controller;

import com.elitesland.scp.pay.service.AccountLinkService;
import com.elitesland.scp.pay.service.PaymentService;
import com.elitesland.scp.pay.vo.PayOrderReqDTO;
import com.elitesland.scp.utils.RandomUtil;
import com.tenpay.business.entpay.mse.sdk.api.Payment;
import com.tenpay.business.entpay.mse.sdk.api.Redirect;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import com.tenpay.business.entpay.mse.sdk.model.Goods;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/test"})
@Validated
public class TestController {
    private static final Logger log = LoggerFactory.getLogger(TestController.class);
    private final PaymentService paymentService;
    private final AccountLinkService accountLinkService;

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u652f\u4ed8\u4e0b\u5355-\u6d4b\u8bd5\u6570\u636e")
    @PostMapping(value={"/mock/mp-pay"})
    public Redirect createTestMPPay(@RequestBody String mpPath) throws EntpayException {
        PayOrderReqDTO payOrderReqDTO = new PayOrderReqDTO();
        payOrderReqDTO.setEntId("100203124444");
        payOrderReqDTO.setEntName("\u5fae\u4f01\u4ed8\u8054\u8c03\u4f01\u4e1a");
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        for (int i = 0; i < 2; ++i) {
            Goods goods = Goods.builder().goodName("\u5546\u54c1\u540d\u79f0").goodNumber(Integer.valueOf(1)).goodAmount(Long.valueOf(8L)).build();
            goodsList.add(goods);
        }
        payOrderReqDTO.setGoods(goodsList);
        payOrderReqDTO.setDeviceId("");
        payOrderReqDTO.setPayerClientIp("127.0.0.7");
        payOrderReqDTO.setPayerUa("idea");
        payOrderReqDTO.setCreateTime(new Date());
        payOrderReqDTO.setPickType("SELF_PICK");
        payOrderReqDTO.setPickDescription("\u63cf\u8ff0");
        Date now = new Date();
        Date expireDate = new Date(now.getTime() + 600000L);
        payOrderReqDTO.setStoreId("123");
        payOrderReqDTO.setStoreName("\u95e8\u5e97\u540d\u79f0");
        payOrderReqDTO.setStoreAreaCode("440300");
        payOrderReqDTO.setMpPath(mpPath);
        String outPaymentId = RandomUtil.getRandom(20);
        payOrderReqDTO.setOutPaymentId(outPaymentId);
        payOrderReqDTO.setAmount(10L);
        payOrderReqDTO.setCurrency("CNY");
        payOrderReqDTO.setExpireTime(expireDate);
        payOrderReqDTO.setGoods(goodsList);
        payOrderReqDTO.setMemo("\u53cc\u9762\u7f8a\u7ed2\uff0c10\uff0c5600");
        payOrderReqDTO.setAttachment("\u53cc\u9762\u7f8a\u7ed2\uff0c10\uff0c5600");
        payOrderReqDTO.setProfitAllocationFlag("API_PROFIT_ALLOCATION");
        Payment payment = this.paymentService.createMpPay(payOrderReqDTO);
        return this.accountLinkService.createPaymentLink(payment.getPaymentId(), outPaymentId, expireDate);
    }

    @ApiOperation(value="\u4e8c\u7ef4\u7801\u652f\u4ed8\u4e0b\u5355-\u6d4b\u8bd5\u6570\u636e")
    @GetMapping(value={"/mock/qrcode_pay"})
    public Redirect createTestQRPay() throws EntpayException {
        log.info("\u4e8c\u7ef4\u7801\u652f\u4ed8\u4e0b\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}");
        String outPaymentId = RandomUtil.getRandom(20);
        PayOrderReqDTO payOrderReqDTO = new PayOrderReqDTO();
        payOrderReqDTO.setOutPaymentId(outPaymentId);
        payOrderReqDTO.setAmount(1L);
        payOrderReqDTO.setCurrency("CNY");
        Date now = new Date();
        Date expireDate = new Date(now.getTime() + 600000L);
        payOrderReqDTO.setExpireTime(expireDate);
        payOrderReqDTO.setEntId("100203124444");
        payOrderReqDTO.setEntName("\u5fae\u4f01\u4ed8\u8054\u8c03\u4f01\u4e1a");
        payOrderReqDTO.setMemo("\u53cc\u9762\u7f8a\u7ed2\uff0c10\uff0c5600");
        payOrderReqDTO.setAttachment("\u53cc\u9762\u7f8a\u7ed2\uff0c10\uff0c5600");
        payOrderReqDTO.setDeviceId("");
        payOrderReqDTO.setPayerClientIp("127.0.0.7");
        payOrderReqDTO.setPayerUa("idea");
        payOrderReqDTO.setCreateTime(new Date());
        payOrderReqDTO.setPickType("SELF_PICK");
        payOrderReqDTO.setPickDescription("\u63cf\u8ff0");
        payOrderReqDTO.setStoreId("123");
        payOrderReqDTO.setStoreName("\u95e8\u5e97\u540d\u79f0");
        payOrderReqDTO.setStoreAreaCode("440300");
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        for (int i = 0; i < 2; ++i) {
            Goods goods = Goods.builder().goodName("\u5546\u54c1\u540d\u79f0").goodNumber(Integer.valueOf(1)).goodAmount(Long.valueOf(8L)).build();
            goodsList.add(goods);
        }
        payOrderReqDTO.setGoods(goodsList);
        payOrderReqDTO.setProfitAllocationFlag("API_PROFIT_ALLOCATION");
        Payment payment = this.paymentService.createQrCodePay(payOrderReqDTO);
        return this.accountLinkService.createPaymentLink(payment.getPaymentId(), outPaymentId, expireDate);
    }

    public TestController(PaymentService paymentService, AccountLinkService accountLinkService) {
        this.paymentService = paymentService;
        this.accountLinkService = accountLinkService;
    }
}

