package com.elitesland.scp.application.facade.vo.resp.mrp;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

@Data
@ApiModel("千元用量")
public class ScpThousandUseVO extends BaseViewModel implements Serializable {

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "门店id")
    private Long stWhId;

    @ApiModelProperty(value = "门店编码	")
    private String stWhCode;

    @ApiModelProperty(value = "门店名称")
    private String stWhName;

    @ApiModelProperty(value = "门店类型")
    private String stWhType;

    @ApiModelProperty(value = "参考日期开始")
    private Date referenceDataStart;

    @ApiModelProperty(value = "参考日期结束")
    private Date referenceDataEnd;

    @ApiModelProperty(value = "有效日期开始")
    private Date validDataStart;

    @ApiModelProperty(value = "有效日期结束")
    private Date validDataEnd;

    @ApiModelProperty(value = "租户ID")
    private Long tenantId;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "记录创建者ID")
    private Long createUserId;

    @ApiModelProperty(value = "记录创建者")
    private String creator;

    @ApiModelProperty(value = "记录创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "记录最后更新者ID")
    private Long modifyUserId;

    @ApiModelProperty(value = "记录最后更新者")
    private String updater;

    @ApiModelProperty(value = "记录最后更新时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty(value = "记录最后更新时间")
    private Integer deleteFlag;

    @ApiModelProperty(value = "锁版本")
    private Integer auditDataVersion;

    @ApiModelProperty(value = "数据归属组织id")
    private Long secBuId;

    @ApiModelProperty(value = "数据归属雇员id")
    private Long secUserId;

    @ApiModelProperty(value = "数据归属公司id")
    private Long secOuId;

    @ApiModelProperty(value = "所属组织ID")
    private Long belongOrgId;

    @ApiModelProperty(value = "租户组织ID")
    private Long tenantOrgId;

    @ApiModelProperty(value = "拓展字段1")
    private String ext1;

    @ApiModelProperty(value = "拓展字段2")
    private String ext2;

    @ApiModelProperty(value = "拓展字段3")
    private String ext3;

    @ApiModelProperty(value = "明细列表")
    private List<ScpThousandUseRefVO> scpThousandUseRefVOList;
}
