package com.elitesland.scp.application.service.scpsman;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeePageQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeePageRespDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitescloud.cloudt.system.provider.org.OrgRpcService;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanComponentPageRespVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanParamVO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanComponentRepoProc;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepoProc;
import com.elitesland.scp.rmi.RmiOrgOuService;
import com.elitesland.support.provider.org.dto.OrgOuRpcDTO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Auther: Mark
 * @Date: 2024/3/22 10:17
 * @Description:
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ScpsmanComponentServiceImpl implements ScpsmanComponentService{
    private final RmiOrgOuService rmiOrgOuService;
   // private final RmiSysOrgService rmiSysOrgService;
    private final ScpsmanComponentRepoProc scpsmanComponentRepoProc;
    @Autowired
    private EmployeeRpcService employeeRpcService;
    @Autowired
    private UdcProvider udcProvider;

    @Autowired
    private OrgRpcService orgRpcService;

    @Autowired
    private ScpsmanInfoRepoProc scpsmanInfoRepoProc;



    @Override
    public PagingVO<SalesmanComponentPageRespVO> salemansComponentPage(SalesmanParamVO paramVO) {
        List<String> agentEmpCodes = new ArrayList<>();
        if(StringUtils.isNotBlank(paramVO.getPhone()) || ObjectUtils.isNotEmpty(paramVO.getOrgId()) || ObjectUtils.isNotEmpty(paramVO.getOrgCode())){
            if(StringUtils.isNotBlank(paramVO.getOrgCode())){
                SysOrgBasicDTO sysOrgBasic = this.getOrgByCode(paramVO.getOrgCode());
                if(ObjectUtils.isEmpty(sysOrgBasic)){
                    return new PagingVO<>();
                }
                paramVO.setOrgId(sysOrgBasic.getId());
            }

            List<String> empCodesParam = this.getEmpCodes(paramVO);
            if(ObjectUtils.isEmpty(empCodesParam)){
                return new PagingVO<>();
            }
            agentEmpCodes.addAll(empCodesParam);
//            paramVO.setCodes(empCodesParam);
        }
        /*if(StringUtils.isNotBlank(paramVO.getCustCode())){
            //查询客户对应的业务员
            String agentEmpCode = crmCustRepoProc.getAgentEmpCodeByCustCode(paramVO.getCustCode());
            if(StringUtils.isNotBlank(agentEmpCode)){
                agentEmpCodes.add(agentEmpCode);
            }else {
                return new PagingVO<>();
            }
        }*/
        paramVO.setCodes(agentEmpCodes);
//        if(ObjectUtils.isNotEmpty(paramVO.getOuId())){
//            List<OrgOuRpcDTO> ous = rmiOrgOuService.findOuDtoList(Collections.singletonList(paramVO.getOuId()),null);
//            if(CollectionUtil.isEmpty(ous)){
//                return new PagingVO<>();
//            }
//            paramVO.setOuCode(ous.get(0).getOuCode());
//        }
        PagingVO<SalesmanComponentPageRespVO> salemansPage = scpsmanComponentRepoProc.salemanComponemtPage(paramVO);
        if(salemansPage.isEmpty()){
            return new PagingVO<>();
        }
        List<String> empCodes = salemansPage.getRecords().stream().map(SalesmanComponentPageRespVO ::getScpsmanNo).collect(Collectors.toList());
        Map<String, SysEmployeeDetailDTO> empMap = this.getEmpMap(empCodes);
        Map<String, String> salesmanTypeUDCMap = udcProvider.getValueMapByUdcCode("yst-suplan", "SCPSMAN_TYPE");
        salemansPage.getRecords().forEach(s ->{
            if(MapUtils.isNotEmpty(empMap) && ObjectUtils.isNotEmpty(empMap.get(s.getScpsmanNo()))){
                s.setName(empMap.get(s.getScpsmanNo()).getFullName());
                s.setPhone(empMap.get(s.getScpsmanNo()).getPhone());
                s.setUserId(empMap.get(s.getScpsmanNo()).getUserId());
                SysEmployeeDetailDTO emp = empMap.get(s.getScpsmanNo());
                if(ObjectUtils.isNotEmpty(emp) && CollectionUtil.isNotEmpty(emp.getOrgList())){
                    SysEmployeeDetailDTO.EmployeeOrg leaderEmp = emp.getOrgList().get(0);
                    s.setOrgName(leaderEmp.getOrgName());
                    s.setOrgId(leaderEmp.getOrgId());
                    if(ObjectUtils.isNotEmpty(leaderEmp.getOrgId())){
                        SysOrgBasicDTO sysOrgBasic = this.getOrgById(leaderEmp.getOrgId());
                        if(ObjectUtils.isNotEmpty(sysOrgBasic)){
                            s.setOrgCode(sysOrgBasic.getCode());
                        }
                    }
                    s.setLeaderUserFullName(leaderEmp.getLeaderUserFullName());
                    s.setLeaderEmployeeCode(leaderEmp.getLeaderEmployeeCode());
                    s.setLeaderUserId(leaderEmp.getLeaderUserId());
                    s.setLeaderEmployeeId(leaderEmp.getLeaderEmployeeId());
                    if(StringUtils.isNotBlank(leaderEmp.getLeaderEmployeeCode())){
                        List<ScpsmanInfoDO> mans =
                                scpsmanInfoRepoProc.getSalesmanByCodes(Collections.singleton(leaderEmp.getLeaderEmployeeCode()));
                        if(CollectionUtil.isNotEmpty(mans)){
                            s.setLeaderSalemansId(mans.get(0).getId());
                        }
                    }
                }
            }
            if(!ObjectUtils.isEmpty(s.getOuId())){
                List<OrgOuRpcDTO> ous = rmiOrgOuService.findOuDtoList(Collections.singletonList(s.getOuId()),null);
                if(CollectionUtil.isNotEmpty(ous)){
                    s.setCurrCode(ous.get(0).getOuCurr());
                }
            }
            if(StringUtils.isNotBlank(s.getScpsmanType()) && ObjectUtils.isNotEmpty(salesmanTypeUDCMap) && ObjectUtils.isNotEmpty(salesmanTypeUDCMap.get(s.getScpsmanType()))){
                s.setScpsmanTypeName(salesmanTypeUDCMap.get(s.getScpsmanType()));
            }

            s.setEnableStatusName(s.getEnableStatus() == 1 ? "启用" : "禁用");
        });
        return salemansPage;
    }

    public Map<String,SysEmployeeDetailDTO> getEmpMap(List<String> empCodes){
        Set<String> codeSet = new HashSet<>(empCodes);
        ApiResult<List<SysEmployeeDetailDTO>> serviceDetailList = employeeRpcService.getDetailListByCode(codeSet);
        if(serviceDetailList.isFailed()){
            throw new BusinessException("查询员工信息失败");
        }
        if(CollectionUtil.isEmpty(serviceDetailList.getData())){
            return new HashMap<>();
        }
        List<SysEmployeeDetailDTO> emps = serviceDetailList.getData();
        return emps.stream().collect(Collectors.toMap(SysEmployeeDetailDTO :: getCode, Function.identity(),(t1, t2) ->t1));

    }

    public SysOrgBasicDTO getOrgByCode(String code){
        ApiResult<SysOrgBasicDTO> apiResult = orgRpcService.getByCode(code);
        if(apiResult.isSuccess() && !ObjectUtils.isEmpty(apiResult.getData())){
            return apiResult.getData();
        }
        return null;
    }

    public SysOrgBasicDTO getOrgById(Long id){
        ApiResult<SysOrgBasicDTO> apiResult = orgRpcService.getById(id);
        if(apiResult.isSuccess() && !ObjectUtils.isEmpty(apiResult.getData())){
            return apiResult.getData();
        }
        return null;
    }

    public List<String> getEmpCodes(SalesmanParamVO paramVO){
        EmployeePageQueryDTO employeePageQueryDTO = new EmployeePageQueryDTO();
      //  employeePageQueryDTO.setType(UdcEnum.CUST_TYPE_SCPSMAN.getValueCode());
        employeePageQueryDTO.setPhone(paramVO.getPhone());
        if(ObjectUtils.isNotEmpty(paramVO.getOrgId())){
            employeePageQueryDTO.setOrgId(paramVO.getOrgId());
        }
        employeePageQueryDTO.setSize(1000);
//        employeePageQueryDTO.setWithoutLeader(true);
        ApiResult<PagingVO<EmployeePageRespDTO>> result = employeeRpcService.queryByPage(employeePageQueryDTO);
        if(result.isFailed()){
            throw new BusinessException("查询员工信息失败");
        }
        if(result.getData().isEmpty()){
            return new ArrayList<>();
        }
        List<EmployeePageRespDTO> emps = result.getData().getRecords();
        return emps.stream().map(EmployeePageRespDTO :: getCode).collect(Collectors.toList());
    }
}
