package com.elitesland.scp.domain.entity.authority;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "scpsman_authority_d")
@org.hibernate.annotations.Table(appliesTo = "scpsman_authority_d", comment = "计划员权限分配明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "计划员权限分配明细", description = "计划员权限分配明细")
@Where(clause = "delete_flag = 0")
public class ScpsmanAuthorityDDO extends BaseModel implements Serializable {
    /** 主表id */
    @ApiModelProperty(name = "主表id")
    @Comment("主表id")
    @Column
    private Long masId ;

    /** 类型 */
    @ApiModelProperty(name = "类型")
    @Comment("类型")
    @Column
    private int type;

    /**
     * 门店id/仓库id
     */
    @ApiModelProperty(name = "门店id/仓库id")
    @Comment("门店id/仓库id")
    @Column
    private Long stWhId;

    /**
     * 门店编码/仓库编码
     */
    @ApiModelProperty(name = "门店编码/仓库编码")
    @Comment("门店编码/仓库编码")
    @Column
    private String stWhCode;

    /**
     * 门店名称/仓库名称
     */
    @ApiModelProperty(name = "门店名称/仓库名称")
    @Comment("门店名称/仓库名称")
    @Column
    private String stWhName;

    @ApiModelProperty(name = "区域")
    @Comment("区域")
    @Column(name = "region", columnDefinition = "varchar(40)")
    private String region;

    @Comment(value = "权限来源，[UDC]yst-suplan:AUTH_SOURCE", defaultValue = "'MANUAL'")
    @Column()
    private String authSource;

    @Comment(value = "权限来源标识")
    @Column()
    private String authSourceId;
}
