package com.elitesland.scp.job.task;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.scp.job.config.JobConstant;
import com.elitesland.scp.job.service.ScpSurveyInvalidJobService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class ScpSurveyInvalidHandler {

    @Autowired
    private ScpSurveyInvalidJobService scpSurveyInvalidJobService;

    @XxlJob(JobConstant.SCP_SURVEY_INVALID_HANDLER)
    public ReturnT<String> scpSurveyInvalidHandler(String param) {
        try {
            scpSurveyInvalidJobService.autoInvalid();
        } catch (Exception e) {
            log.error("问卷自动失效定时任务执行失败：", e);
            throw new BusinessException("问卷自动失效定时任务执行失败:" + e.getMessage());
        }
        return ReturnT.SUCCESS;
    }
}
